/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file simpleobject.cc
  \brief a simple object.
*/

#include "leg/libs/scene/simpleobject.h"

namespace leg
{
namespace libs
{
namespace scene
{

const std::string SimpleObject::main_id   = "LegObject";
const std::string SimpleObject::sub_id    = "LegSimpleObject";

SimpleObject::SimpleObject(): Object()
{
}

SimpleObject::SimpleObject (const SimpleObject& o):
   Object (static_cast<const Object&> (o))
{
}

void
SimpleObject::Init()
{
}

void
SimpleObject::Update()
{
}

SimpleObject*
SimpleObject::Clone()
{
   return new SimpleObject (*this);
}

void
SimpleObject::Copy (const SimpleObject& o)
{
   Object::Copy (static_cast<const Object&> (o));
}

const Entity::Propriety
SimpleObject::GetPropriety() const
{
   return none;
}

// in their respective files:

const std::string SimpleCar::main_id = "LegSimpleObject";
const std::string SimpleCar::sub_id  = "LegSimpleCar";

const std::string ArticulatedObject::main_id = "LegDynamicObject";
const std::string ArticulatedObject::sub_id  = "LegArticulatedObject";

}
}
}
