/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file pointlight.cc
  \brief point light.
*/

#include "leg/libs/scene/pointlight.h"

namespace leg
{
namespace libs
{
namespace scene
{

const std::string PointLight::main_id   = "LegLight";
const std::string PointLight::sub_id    = "LegPointLight";

PointLight::PointLight(): Light()
{
}

PointLight::PointLight (const PointLight& c): 
   Light (static_cast<const Light&> (c))
{
   Copy (c);
}

const PointLight&
PointLight::operator = (const PointLight& c)
{
   Parent::Copy (static_cast<const Parent&> (c));
   Copy (c);
   
   return *this;
}

void
PointLight::Read (std::ifstream& ifs)
{
   Parent::Read (ifs);
}

void
PointLight::Write (std::ofstream& ofs)
{
   Parent::Write (ofs);
}

const std::string
PointLight::GetMainId()
{
   return main_id;
}

const std::string
PointLight::GetSubId()
{
   return sub_id;
}

void
PointLight::Copy (const PointLight& c)
{
}

void
PointLight::Init()
{
}

void
PointLight::Update()
{
}

PointLight*
PointLight::Clone()
{
   return new PointLight (*this);
}

const Entity::Propriety
PointLight::GetPropriety() const
{
   return Entity::light_object;
}

}
}
}
