/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file light.cc
  \brief light.
*/

#include "leg/libs/scene/light.h"

namespace leg
{
namespace libs
{
namespace scene
{

const std::string Light::main_id   = "LegLight";
const std::string Light::sub_id    = "none";

Light::Light(): Entity()
{
}

Light::Light (const Light& c): 
   Entity (static_cast<const Entity&> (c))
{
   Copy (c);
}

const Light&
Light::operator = (const Light& c)
{
   Entity::Copy (static_cast<const Entity&> (c));
   Copy (c);
   
   return *this;
}

void
Light::Read (std::ifstream& ifs)
{
   Entity::Read (ifs);
   ifs >> amb >> dif >> spe;
}

void
Light::Write (std::ofstream& ofs)
{
   Entity::Write (ofs);
   ofs << amb << std::endl;
   ofs << dif << std::endl;
   ofs << spe << std::endl;
}

const std::string
Light::GetMainId()
{
   return main_id;
}

const std::string
Light::GetSubId()
{
   return sub_id;
}

void
Light::Copy (const Light& c)
{
   amb = c.amb;
   dif = c.dif;
   spe = c.spe;
}

}
}
}
