/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file factory.cc
  \brief abstract factory
*/

#include "leg/libs/scene/factory.h"

namespace leg
{
namespace libs
{
namespace scene
{
namespace reg
{

Entity*
CreateSimpleCamera()
{
   Camera *tmp = new SimpleCamera;

   return static_cast<Entity*> (tmp);
}

Entity*
CreateSimpleObject()
{
   Object *tmp = new SimpleObject;

   return static_cast<Entity*> (tmp);
}

Entity*
CreateStaticObject()
{
   Object *tmp = new StaticObject;

   return static_cast<Entity*> (tmp);
}

Entity*
CreatePointLight()
{
   Light *tmp = new PointLight;

   return static_cast<Entity*> (tmp);
}

Entity*
CreateInfiniteLight()
{
   Light *tmp = new InfiniteLight;

   return static_cast<Entity*> (tmp);
}

Entity*
CreateSimpleCar()
{
   Object *tmp = new SimpleCar;

   return static_cast<Entity*> (tmp);
}

Entity*
CreateArticulatedObject()
{
   DynamicObject *tmp = new ArticulatedObject;

   return static_cast<Entity*> (tmp);
}

const bool is_simple_camera_registered = 
ObjectFactory::Instance().Register (SimpleCamera::main_id, SimpleCamera::sub_id, CreateSimpleCamera);

const bool is_simple_object_registered = 
ObjectFactory::Instance().Register (SimpleObject::main_id, SimpleObject::sub_id, CreateSimpleObject);

const bool is_static_object_registered = 
ObjectFactory::Instance().Register (StaticObject::main_id, StaticObject::sub_id, CreateStaticObject);

const bool is_point_light_registered = 
ObjectFactory::Instance().Register (PointLight::main_id, PointLight::sub_id, CreatePointLight);

const bool is_infinite_light_registered = 
ObjectFactory::Instance().Register (InfiniteLight::main_id, InfiniteLight::sub_id, CreateInfiniteLight);

const bool is_simple_car_registered = 
ObjectFactory::Instance().Register (SimpleCar::main_id, SimpleCar::sub_id, CreateSimpleCar);

const bool is_articulated_object_registered =
ObjectFactory::Instance().Register (ArticulatedObject::main_id, ArticulatedObject::sub_id, CreateArticulatedObject);

} // reg namespace

}
}
}
