/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 12/08/04 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file entity.cc
  \brief A class representing any entity with a location.
*/

#include "leg/libs/scene/entity.h"
#include "leg/support/utils/errors.h"
#include <cstdlib>

namespace leg
{
namespace libs
{
namespace scene
{

const std::string Entity::main_id   = "LegEntity";
const std::string Entity::sub_id    = "none";
      Timing	  Entity::timer;
      game_time	  Entity::u_clock   = 0;
      game_time	  Entity::u_dt	    = 0;
   
      int	  unnamed_counter   = 0;


Entity::Entity(): model_filename ("none"),
		  name ("Unnamed")
{
   char c[4] = "";
   std::sprintf (c, "%d", unnamed_counter);
   name += c;
   ++unnamed_counter;
}

Entity::Entity (const Entity& e)
{
   Copy (e);
}

Entity::~Entity()
{
}

const Entity&
Entity::operator = (const Entity& e)
{
   Copy (e);
   
   return *this;
}

void
Entity::Copy (const Entity& e)
{
   pos = e.pos;
   ori = e.ori;
   size= e.size;
   model_filename = e.model_filename;
   name = e.name;
}

void
Entity::Read (std::ifstream& ifs)
{
   ifs >> name >> pos >> ori >> size >> model_filename;
   ReadExtra (ifs);
}

void
Entity::Write (std::ofstream& ofs)
{
   ofs << name << std::endl;
   ofs << pos << std::endl;
   ofs << ori << std::endl;
   ofs << size << std::endl;
   ofs << model_filename << std::endl;
   WriteExtra (ofs);
}

void
Entity::SetPosition (const Vector& p)
{
   pos = p;
}

Vector&
Entity::GetPosition()
{
   return pos;
}

void
Entity::SetOrientation (const Vector& o)
{
   ori = o;
}

Vector&
Entity::GetOrientation()
{
   return ori;
}

void
Entity::SetSize (const Vector& s)
{
   size = s;
}

Vector&
Entity::GetSize()
{
   return size;
}

void
Entity::SetModelFilename (const std::string& s)
{
   model_filename = s;
}

const std::string&
Entity::GetModelFilename()
{
   return model_filename;
}

void
Entity::ReadExtra (std::ifstream& ifs)
{
   unsigned int nb, i;
   std::string e_name, e_value;

   ifs >> nb;

   if (nb != 0){
      for (i = 0; i < nb; ++i){
	 ifs >> e_name >> e_value;
	 args[e_name].push_back (e_value);
      }
   }
}

void
Entity::WriteExtra (std::ofstream& ofs)
{
   unsigned int nb;
   ExtraArgs::const_iterator i;
   Values::const_iterator j;
   
   nb = 0;
   i = args.begin();

   for (; i != args.end(); ++i)
      nb += (*i).second.size();

   ofs << nb << std::endl;

   if (!nb)
      return;
   
   i = args.begin();
   
   for (; i != args.end(); ++i){
      ofs << (*i).first << " ";
      j = (*i).second.begin();

      for (; j != (*i).second.end(); ++j)
	 ofs << (*j) << std::endl;
   }
}

}
}
}
