/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file camera.cc
  \brief camera.
*/

#include "leg/libs/scene/camera.h"

namespace leg
{
namespace libs
{
namespace scene
{

const std::string Camera::main_id   = "LegCamera";
const std::string Camera::sub_id    = "none";

Camera::Camera(): Entity()
{
}
   
Camera::Camera (const Camera& c):
   Entity (static_cast<const Entity&> (c))
{
}
   
void
Camera::CalculateUpVector()
{
   Vector o (1,0,0);
   o.RotateZ (ori.z);
   o.RotateY (ori.y);
   Vector v1 = o;
   Vector v3 = v1;
   v3.y = 0;
   v3.Normalize();
   v3.RotateY (pi_2);
   up = v1.Cross(v3);
   aim.x = pos.x + o.x;
   aim.y = pos.y + o.y;
   aim.z = pos.z + o.z;
}

void
Camera::Copy (const Camera& c)
{
   aim = c.aim;
   up = c.up;
}

void
Camera::Read (std::ifstream& ifs)
{
   Entity::Read (ifs);
   ifs >> aim >> up;
}

void
Camera::Write (std::ofstream& ofs)
{
   Entity::Write (ofs);
   ofs << aim << std::endl;
   ofs << up << std::endl;
}

}
}
}
