/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: mousecoord.cc,v 1.1 2004/06/19 11:36:07 jd Exp $

   Created 06/16/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/interactivity/mousecoord.h
  \brief mouse coord controler.
*/

#include "leg/libs/interactivity/mousecoord.h"

namespace leg
{
namespace libs
{
namespace interactivity
{

   MouseCoord::MouseCoord (unsigned int w, unsigned int h): support::maths::Point<2> (),
							    is_ranged_to_size (false),
							    scr_width (w),
							    scr_height (h),
							    sensibility (1),
							    x (0), y (0)
   {
   }

   MouseCoord::~MouseCoord ()
   {
   }
   
   void
   MouseCoord::Set (unsigned int vx, unsigned int vy)
   {
      if ((vx > scr_width) || (vy > scr_height))
	 leg::support::utils::Warning ("coordinates out of screen size will be truncated !!",
		  "leg::libs::interactivity::MouseCoord::Set (uint,uint)");

      el[0] = vx;
      el[1] = vy;

      x = el[0];
      y = el[1];

      is_ranged_to_size = false;
   }

   void
   MouseCoord::Get (const real& mx, const real& my)
   {
      real& pmx = const_cast<real&> (mx);
      pmx = x;
      
      real& pmy = const_cast<real&> (my);
      pmy = y;
   }

   void
   MouseCoord::RangeToSize ()
   {
      real& a= el[0];
      real& b= el[1];

      a/=scr_width;
      b/=scr_height;

      Range();

      is_ranged_to_size = true;
   }

   bool
   MouseCoord::IsRangedToSize ()
   {
      return is_ranged_to_size;
   }

   void
   MouseCoord::Range ()
   {
      real& a= el[0];
      real& b= el[1];
      
      if (a > 1)
	 a = 1;
      else if (a < 0)
	 a = 0;
      if (b > 1)
	 b = 1;
      else if (b < 0)
	 b = 0;

      x = a;
      y = b;
   }

   void
   MouseCoord::SetSensibility (float s)
   {
      if (s > 0)
	 sensibility = s;
   }

   float
   MouseCoord::GetSensibility ()
   {
      return sensibility;
   }

}
}
}
