/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.



   Created 4/26/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/graphics/guile.cc
  \brief Guile bindings for graphics.
*/

#include "leg/libs/graphics/graphics.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

namespace leg
{
namespace libs
{
namespace graphics
{

using namespace support;
using namespace lighting;

#if GUILE

namespace internal
{
  void SetLightAmbient (SmartPtr<Light> l, real r, real g, real b)
  {
    l->SetAmbient (Color (r, g, b));
  }

  real GetLightAmbientR (SmartPtr<Light> l)
  {
    return l->GetAmbient ().b;
  }

  real GetLightAmbientG (SmartPtr<Light> l)
  {
    return l->GetAmbient ().b;
  }

  real GetLightAmbientB (SmartPtr<Light> l)
  {
    return l->GetAmbient ().b;
  }


  void SetLightDiffuse (SmartPtr<Light> l, real r, real g, real b)
  {
    l->SetDiffuse (Color (r, g, b));
  }

  real GetLightDiffuseR (SmartPtr<Light> l)
  {
    return l->GetDiffuse ().b;
  }

  real GetLightDiffuseG (SmartPtr<Light> l)
  {
    return l->GetDiffuse ().b;
  }

  real GetLightDiffuseB (SmartPtr<Light> l)
  {
    return l->GetDiffuse ().b;
  }


  void SetLightSpecular (SmartPtr<Light> l, real r, real g, real b)
  {
    l->SetSpecular (Color (r, g, b));
  }

  real GetLightSpecularR (SmartPtr<Light> l)
  {
    return l->GetSpecular ().b;
  }

  real GetLightSpecularG (SmartPtr<Light> l)
  {
    return l->GetSpecular ().b;
  }

  real GetLightSpecularB (SmartPtr<Light> l)
  {
    return l->GetSpecular ().b;
  }


  SmartPtr<SpotLight>
  NewSpotLight (real x, real y, real z)
  {
    return SmartPtr<SpotLight> (new SpotLight (Point<3> (x, y, z)));
  }


  void SetSpotLightDirection (SmartPtr<SpotLight> l, real x, real y, real z)
  {
    l->SetSpotDirection (Vector<3> (x, y, z));
  }

  real GetSpotLightDirectionX (SmartPtr<SpotLight> l)
  {
    return l->GetSpotDirection ().x;
  }

  real GetSpotLightDirectionY (SmartPtr<SpotLight> l)
  {
    return l->GetSpotDirection ().y;
  }

  real GetSpotLightDirectionZ (SmartPtr<SpotLight> l)
  {
    return l->GetSpotDirection ().z;
  }


  SmartPtr<PointLight>
  NewPointLight (real x, real y, real z)
  {
    return SmartPtr<PointLight> (new PointLight (Point<3> (x, y, z)));
  }


  SmartPtr<InfiniteLight>
  NewInfiniteLight (real x, real y, real z)
  {
    InfiniteLight *p = new InfiniteLight (Point<3> (x, y, z));
    return SmartPtr<InfiniteLight> (p);
  }
}

struct GuileStartup
{
  GuileStartup ()
  {
    guile::internal::StartGuile ();


    using namespace graphics::internal;

    guile::AddType<Light> ("light");
    guile::AddTypeParent<Light, Entity> ();


    guile::AddVoidMemberBinding0<Light, &Light::Enable> ("light-enable!");
    guile::AddVoidMemberBinding0<Light, &Light::Disable> ("light-disable!");
    guile::AddVoidMemberBinding0<Light, &Light::Draw> ("light-draw!");


    guile::AddVoidBinding4<SmartPtr<Light>, real, real, real, SetLightAmbient> ("set-light-ambient-color!");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightAmbientR> ("get-light-ambient-r");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightAmbientG> ("get-light-ambient-g");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightAmbientB> ("get-light-ambient-b");


    guile::AddVoidBinding4<SmartPtr<Light>, real, real, real, SetLightDiffuse> ("set-light-diffuse-color!");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightDiffuseR> ("get-light-diffuse-r");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightDiffuseG> ("get-light-diffuse-g");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightDiffuseB> ("get-light-diffuse-b");


    guile::AddVoidBinding4<SmartPtr<Light>, real, real, real, SetLightSpecular> ("set-light-specular-color!");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightSpecularR> ("get-light-specular-r");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightSpecularG> ("get-light-specular-g");
    guile::AddBinding1<real, SmartPtr<Light>, GetLightSpecularB> ("get-light-specular-b");


    guile::AddVoidMemberBinding1<Light, real, &Light::SetConstantAttenuation> ("set-light-constant-attenuation!");
    guile::AddVoidMemberBinding1<Light, real, &Light::SetLinearAttenuation> ("set-light-linear-attenuation!");
    guile::AddVoidMemberBinding1<Light, real, &Light::SetQuadraticAttenuation> ("set-light-quadratic-attenuation!");

    guile::AddMemberBinding0<Light, real, &Light::GetConstantAttenuation> ("get-light-constant-attenuation");
    guile::AddMemberBinding0<Light, real, &Light::GetLinearAttenuation> ("get-light-linear-attenuation");
    guile::AddMemberBinding0<Light, real, &Light::GetQuadraticAttenuation> ("get-light-quadratic-attenuation");



    guile::AddType<SpotLight> ("spot-light");
    guile::AddTypeParent<SpotLight, Light> ();

    guile::AddBinding3<SmartPtr<SpotLight>, real, real, real, NewSpotLight> ("new-spot-light");

    guile::AddVoidBinding4<SmartPtr<SpotLight>, real, real, real, SetSpotLightDirection> ("set-spot-light-direction!");
    guile::AddBinding1<real, SmartPtr<SpotLight>, GetSpotLightDirectionX> ("get-spot-light-direction-x");
    guile::AddBinding1<real, SmartPtr<SpotLight>, GetSpotLightDirectionY> ("get-spot-light-direction-y");
    guile::AddBinding1<real, SmartPtr<SpotLight>, GetSpotLightDirectionZ> ("get-spot-light-direction-z");



    guile::AddType<PointLight> ("point-light");
    guile::AddTypeParent<PointLight, Light> ();

    guile::AddBinding3<SmartPtr<PointLight>, real, real, real, NewPointLight> ("new-point-light");



    guile::AddType<InfiniteLight> ("infinite-light");
    guile::AddTypeParent<InfiniteLight, Light> ();

    guile::AddBinding3<SmartPtr<InfiniteLight>, real, real, real, NewInfiniteLight> ("new-infinite-light");
  }
} guile_startup;

#endif // GUILE

}
}
}
