;; This file is part of GNU Libraries and Engines for Games.
;; 
;; $Id: timing.scm,v 1.3 2004/04/30 20:15:54 jechk Exp $
;; $Log: timing.scm,v $
;; Revision 1.3  2004/04/30 20:15:54  jechk
;; Big merge.  See ChangeLog for details.
;;
;; Revision 1.2  2004/03/03 06:08:51  jechk
;; Added some Scheme utility functions.
;;
;; Revision 1.1  2004/03/03 02:05:22  jechk
;; Merged many changes.  See ChangeLog for details.
;;
;; 
;; Created 2/18/04 by Jeff Binder <bindej@rpi.edu>
;; 
;; Copyright (c) 2004 Free Software Foundation
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public
;; License as published by the Free Software Foundation; either
;; version 2.1 of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;; General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public
;; License along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


; Set this to a timing object used by the functions in this file
; before using them.
(define timing #f)

; Returns the current time.
(define (current-time)
  (get-current-time timing))

; Evaluate the arguments at the specified game time in another thread.
; The return value is unspecified.
(define-macro (at-time time . body)
  `(call-at-time ,time (lambda () ,@body)))

; Call the specified function at the specified game time in another
; thread.  The return value is unspecified.
(define (call-at-time time thunk)
  (let ((timer (new-timer timing thunk)))
    (timer-set! timer time))
  *unspecified*)

; Evaluate the arguments after the specified game time interval in
; another thread.  The return value is unspecified.
(define-macro (after-time time . body)
  `(call-after-time ,time (lambda () ,@body)))

; Call the specified function after the specified game time interval
; in another thread.  The return value is unspecified.
(define (call-after-time time thunk)
  (let ((timer (new-timer timing thunk)))
    (timer-set! timer (+ (current-time) time)))
  *unspecified*)
