/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xevent.h,v 1.5 2004/06/15 12:56:21 jd Exp $

   Created 04/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xevent.h
  \brief X event handlings.
*/

#ifndef LEG_SUPPORT_WINDOW_SDL_XEVENT_H
#define LEG_SUPPORT_WINDOW_SDL_XEVENT_H

#include "../event.h"
#include "../firsttypes.h"
#include "../attributes.h"

namespace leg
{
namespace support
{
namespace window
{

class SDLEvent: public BaseEvent
{
   private:

   SDLEvent();
   
   internal::Display *const disp;
 
   public:

   SDLEvent (internal::Display *const d, Attributes& a); // we should require window attributes too.

   ~SDLEvent();

   void
   Update();

   private:

   void
   MakeKeyPress (Key k);

   void
   MakeKeyRelease (Key k);

   void
   MakeMouseButtonPress (MouseButton b);

   void
   MakeMouseButtonRelease (MouseButton b);
};

//! X events typedefs into Event for portability because SDLEvent interface seems
//! to fit well for all systems.
typedef SDLEvent Event;

}
}
}

#endif
