/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xattributes.h,v 1.2 2004/05/09 23:33:55 jd Exp $

   Created 03/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xattributes.h
  \brief X-Free Attributes for gl window rendering support.
*/

#ifndef LEG_SUPPORT_WINDOW_SDL_SLDATTRIBUTES_H
#define LEG_SUPPORT_WINDOW_SDL_SDLATTRIBUTES_H

#include "../attributes.h"
#include <SDL/SDL.h>

namespace leg
{
namespace support
{
namespace window
{

class SDLAttributes: public Attributes
{
   public:

   //! Default and only constructor.
   /*!
    * This sets window width to 800 and height to 600 by default.
    */
   SDLAttributes (unsigned int w=800, unsigned int h=600): Attributes (w,h)
   {
   }

   ~SDLAttributes()
   {
   }

   SDLAttributes (const SDLAttributes& a): Attributes (static_cast<const Attributes&> (a))
   {
   }
   
   SDLAttributes&
   operator = (const SDLAttributes&)
   {
      return *this;
   }

   //! Creates the glx 1.3 attributes array values.
   /*! 
    * Creates the glx attributes regarding the configuration that the user 
    * decided before by any call to member functions of the based class 
    * (Attributes). You'll have to call to this function after changing the 
    * attributes values.
    * 
    * @sa Attributes.
    */
   void
   SetAttributes()
   {
      SDL_GL_SetAttribute (SDL_GL_DOUBLEBUFFER,1);
      SDL_GL_SetAttribute (SDL_GL_STENCIL_SIZE,8);
      SDL_GL_SetAttribute (SDL_GL_ALPHA_SIZE,4);
   }

   int* const
   GetGLWMAttributes (int &nb)
   {
      return 0;
   }

   //! Set the keyboard auto repeat mode.
   /*!
    * Warning: this affects all the XFree server, so that changes are kept 
    * after any programs lifetime has ended. So, changes back the values
    * before exiting any program (this is done automatically be glx windows).
    */
   void
   SetKeyboardAutoRepeatMode (internal::Display *disp, bool mode)
   {
      switch (mode){
	 case false:
	    SDL_EnableKeyRepeat (0,0);
	    break;
	 case true:
	    SDL_EnableKeyRepeat (SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
	    break;
      }
   }
};
	
}
}
}

#endif
