/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: displayconnect.h,v 1.3 2004/05/09 23:33:35 jd Exp $

   $Log: displayconnect.h,v $
   Revision 1.3  2004/05/09 23:33:35  jd
   directory support for all the project, best windowing support, best interactivity support...

   Revision 1.2  2004/04/30 01:11:43  jd
   new revision

   Revision 1.1  2004/03/22 03:18:53  jd
   glx 1.2 and 1.3 support



 
   Created 03/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/displayconnect.h
  \brief Base class for display and versions support.
*/

#ifndef LEG_SUPPORT_WINDOW_SDL_DISPLAY_CONNECT_H
#define LEG_SUPPORT_WINDOW_SDL_DISPLAY_CONNECT_H

#include "firsttypes.h"
#include "../displayconnect.h"

namespace leg
{
namespace support
{
namespace window
{

class SDLDisplayConnect: public DisplayConnect
{
   public:

   SDLDisplayConnect(): DisplayConnect()
   {
   }

   ~SDLDisplayConnect()
   {
   }
   
   //! Open a new connection to the display.
   /*!
    * Please refer to your OS dependant version.
    */
   void
   Open();

   //! Close it.
   void
   Close()
   {
   }

   //! Calculates and returns the glx major and minor versions.
   /*!
    * You must have open a connection before calling this function.
    */
   void
   GetGLWMVersion (int& rel_maj, int& rel_min)
   {
      rel_maj = 0;
      rel_min = 0;
   }

   protected:

   //! Check if our display supports threads.
   void 
   CheckThreadSupport()
   {
   }
};

typedef SDLDisplayConnect DisplayConnection;

}
}
}
#endif
