/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xwindow.h,v 1.4 2004/06/15 12:56:21 jd Exp $

   Created 03/09/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glx13window.h
  \brief X window for gl rendering support.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX_GLX_13_WINDOW_H
#define LEG_SUPPORT_WINDOW_GLX_GLX_13_WINDOW_H

#include "glxwindow.h"	// base glx window
#include "../drawable.h"
#include "glx13drawableimpl.h"

namespace leg
{
namespace support
{
namespace window
{

//! GLX 1.3 Window window.
/*!
 * GLX 1.3 XFree window for leg.
 *
 * status:
 *    working on window mode only for the moment.
 *
 * info:
 *    This won't work for glx 1.2 and previous releases.
 *
 * @sa Window, BaseGLGLX13Window, GLX12Window, GLX13DrawableImpl.
 */
class GLX13Window: public BaseGLXWindow
{
   protected:

   typedef Drawable<internal::GLX13DrawableImpl>   DrawableType;

   AttrType		attr;	    //!< x attributes.
   DrawableType		*drawable;  //!< hard drawable.
   
//   internal::FbConfig	*config;	  //!< glx frame buffer config.

   //! Only available constructor.
   GLX13Window (DisplayConnect& disp);

   ~GLX13Window();
   
   //! Create the window.
   /*!
    * For almost all the class functions, please look at the Window class 
    * documentation.
    * 
    * @sa Window
    */
   void
   Create();

   //! Destroys the window.
   void
   Destroy();

   void 
   SetAttributes (const Attributes&);

   AttrType& 
   GetAttributes();
   
   BaseDrawable&
   GetDrawable();
   
   void
   ShowCursor (bool);

   private:

   internal::FbConfig* const
   CreateConfig();

   void
   CreateVisual();

   void
   CreateMainWindow();
};

}
}
}
#endif
