/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx12window.h,v 1.5 2004/06/14 15:14:38 jd Exp $

   Created 03/16/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glx12window.h
  \brief XFree glx 1.2 compatibility window impl.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX12WINDOW_H
#define LEG_SUPPORT_WINDOW_GLX12WINDOW_H

#include "glxwindow.h"
#include "../drawable.h"
#include "glx12drawableimpl.h"

namespace leg
{
namespace support
{
namespace window
{

//! Glx 1.2 window.
/*! 
 * You must use this type whenever your system does not support glx 1.3. It 
 * appears glx 1.3 is not free, so you will use this class the most of time.
 * However, you may never care about the real class used for windowing as it
 * tries to provide a system-compatible one each time it is possible (with
 * typedefing into OSWindow).
 *
 * status:
 *    working.
 *
 * info:
 *    none.
 *
 * @sa Window, GLX13Window, BaseGLXWindow, GLX12DrawableImpl, OSWindow.
 */
class GLX12Window: public BaseGLXWindow
{
   protected:
   
   typedef Drawable<internal::GLX12DrawableImpl> DrawableType;

   DrawableType		*drawable;

   GLX12Window (DisplayConnect& disp);

   ~GLX12Window();

   void 
   Create();
   
   void 
   Destroy();
   
   void 
   SetAttributes (AttrType& attr);
   
   AttrType& 
   GetAttributes();
   
   void
   DoCreate();

   BaseDrawable&
   GetDrawable();

   void
   ShowCursor (bool);
};

}
}
}

#endif

