/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx12drawableimpl.h,v 1.2 2004/05/21 23:15:10 jd Exp $

   Created 03/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glx12drawableimpl.h
  \brief glx 1.2 drawable implementation.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX_GLX12DRAWABLEIMPL_H
#define LEG_SUPPORT_WINDOW_GLX_GLX12DRAWABLEIMPL_H

#include "glxdrawableimpl.h"

namespace leg
{
namespace support
{
namespace window
{

namespace internal
{

//! rendering drawable impl.
/*!
 * os-dependant implementation of drawable.
 * This is the default for GNU systems running on XFree <= 4.3.
 *
 * status: 
 *    working. earlier status.
 *
 * info: 
 *    The functions trie to be named seemly like for X and glX.
 *    There are some exceptions designed in their comments.
 *    Please, refer to glX 1.3 and XFree 4 lib documentation for more details.
 */
class GLX12DrawableImpl: public GLXDrawableImpl
{
   public:

   GLX12DrawableImpl();

   private:

   GLX12DrawableImpl (const GLX12DrawableImpl&);

   public:
   
   ~GLX12DrawableImpl();

   //! Creates a context.
   /*!
    * Create a context and allow shared to be a shared
    * context for the contextx memory.
    * Please, refer to glXCreateContextNew() for more details.
    */
   internal::Context
   CreateContext (internal::Context shared);

   //! Destroy the context given in argument.
   void
   DestroyContext (internal::Context c);

   //! Enter the context.
   /*!
    * Enter the context for enabling rendering possibilities.
    * This calls glXMakeContextCurrent().
    */
   void
   EnterContext (internal::Context c);

   //! Leave the current context.
   /*!
    * This leaves the current context, and does not take care
    * of the given context argument given. This argument may
    * be needed for some portability or be erased if not.
    */
   void
   LeaveContext (internal::Context c=0);

   //! Return the current context.
   inline internal::Context
   GetCurrentContext ()
   {
      return glXGetCurrentContext();
   }

   //! Create the glx drawable.
   /*!
    * Create the glx drawable that could have rendering
    * commands into it (as gl functions).
    */
   void
   CreateDrawable (int *glx_attr);

   //! Destroys the glx drawable.
   /*!
    * This function has no effect under glx 1.2.
    */
   void
   DestroyDrawable ();

   //! Swap the rendering buffers.
   void
   SwapBuffers();

   //! Create and get the visual.
   XVisualInfo* const
   GetVisual (int scr, int *glx_attr);
   
   private:
   
   GLX12DrawableImpl& operator= (const GLX12DrawableImpl&);
};

}// namespace internal
}
}
}
#endif
