/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: abstractwindow.h,v 1.9 2004/06/15 12:56:13 jd Exp $

   Created 03/10/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file support/window/abstractwindow.h
  \brief Window for gl rendering support
*/

#ifndef LEG_SUPPORT_WINDOW_ABSTRACT_WINDOW_H
#define LEG_SUPPORT_WINDOW_ABSTRACT_WINDOW_H

namespace leg
{
namespace support
{
namespace window
{

class DisplayConnect;

//!Common abstract window for users final type.
/*!
 * At this first layer level, AbstractWindow should be the default user's type
 * to be used; it could be the dynamic type of a polymorphic instanciation too.
 * This class allow to ensure the system-specific window versions will 
 * implement a compatible interface, avoiding any possible member function
 * misses or mismatches.
 * 
 * template argument description:
 *    Win is the system-specific class that inherits from support::Window and
 *    so that providing a matching interface. If you don't want to take care
 *    about this type, support::OSWindow is a good choice.
 *
 * status:
 *    works.
 *
 * info:
 *    No copy neither assignements is allowed.
 * 
 * @sa Window,OSWindow.
 */
template
<
   class Win
>
class AbstractWindow: public Win
{
   AbstractWindow (const AbstractWindow&);
   
   const AbstractWindow& operator = (const AbstractWindow&);

   public:
   
   typedef typename Win::AttrType Attr;

   typedef typename Win::DrawableType Drawable;

   //! The only available constructor.
   AbstractWindow (DisplayConnect& disp): Win (disp)
   {
   }

   ~AbstractWindow()
   {
   }

   //! Create.
   using Win::Create;

   using Win::SwitchToFullScreen;

   using Win::SwitchToWindow;

   using Win::GetAttributes;

   using Win::GetDrawable;

   using Win::ShowCursor;
   
   protected:
   
   //! Window automatically destroys on destruction.
   using Win::Destroy;
};

}
}
}
#endif
