/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: errors.h,v 1.3 2004/06/15 07:18:53 jd Exp $

   Created 03/12/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/errors.h
  \brief First support of all default error/warns... handlings.
*/

#ifndef LEG_SUPPORT_UTILS_ERRORS_H
#define LEG_SUPPORT_UTILS_ERRORS_H

#include "issue.h"
#include "error.h"
#include "warning.h"
#include "infos.h"
#include "message.h"
#include "log.h"

namespace leg
{
namespace support
{
namespace utils
{
#ifdef LEG_USE_LOG

//! When using logs, Warning is a typedef of this type.
/*!
 * @sa support::utils::error::Warning.
 */
typedef Message<support::utils::error::Warning,Log> Warning;

//! When using logs, Error is a typedef of this type.   
/*!
 * @sa support::utils::error::Error.
 */
typedef Message<support::utils::error::Error,Log> Error;

//! When using logs, Info is a typedef of this type.   
/*!
 * @sa support::utils::error::Info.
 */
typedef Message<support::utils::error::Info,Log> Info;
#else

//! When not using logs, Warning is a typedef of this type.   
/*!
 * @sa support::utils::error::Warning.
 */
typedef Message<support::utils::error::Warning,NoLog> Warning;

//! When not using logs, Error is a typedef of this type.   
/*!
 * @sa support::utils::error::Error.
 */
typedef Message<support::utils::error::Error,NoLog> Error;

//! When not using logs, Info is a typedef of this type.   
/*!
 * @sa support::utils::error::Info.
 */
typedef Message<support::utils::error::Info,NoLog> Info;
#endif
}
}
}
#endif
