/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: graphiccard.h,v 1.1 2004/06/08 20:05:15 jd Exp $

   Created 06/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/system/graphiccard.h
  \brief Try to take information on the graphic card.
*/

#ifndef LEG_SUPPORT_SYSTEM_GRAPHIC_CARD_H
#define LEG_SUPPORT_SYSTEM_GRAPHIC_CARD_H

#include <GL/gl.h>
#include <GL/glu.h>
#include <string>

namespace leg
{

namespace support
{

namespace system
{

class GraphicCard
{
   protected:

   std::string vendor;
   
   std::string name; // renderer

   std::string gl_extensions;

   std::string glu_extensions;

   std::string gl_version;

   std::string glu_version;

   unsigned int gl_maj, gl_min;

   GraphicCard (const GraphicCard&);
   
   const GraphicCard 
   operator = (const GraphicCard&);
   
   public:

   GraphicCard(): name ("unknown"),
		  gl_extensions ("none"),
		  gl_maj (1),
		  gl_min (1)
   {
   }

   ~GraphicCard()
   {
   }

   const std::string&
   GetNameFromGl()
   {
      const char* r_str = reinterpret_cast<const char*> (glGetString (GL_RENDERER));
      name = r_str;

      return name;
   }

   const std::string&
   GetExtensionsFromGl()
   {
      const char* r_ext = reinterpret_cast<const char*> (glGetString (GL_EXTENSIONS));
      gl_extensions = r_ext;

      return gl_extensions;
   }

   const std::string&
   GetExtensionsFromGlu()
   {
      const char* r_ext = reinterpret_cast<const char*> (gluGetString (GLU_EXTENSIONS));
      glu_extensions = r_ext;

      return glu_extensions;
   }


   const std::string&
   GetVersionFromGl()
   {
      const char* r_ver = reinterpret_cast<const char*> (glGetString (GL_VERSION));
      gl_version = r_ver;

      return gl_version;
   }

   const std::string&
   GetVendorFromGl()
   {
      const char* r_ven = reinterpret_cast<const char*> (glGetString (GL_VENDOR));
      vendor = r_ven;

      return vendor;
   }
   
   inline const std::string&
   GetName()
   {
      return name;
   }

   inline const std::string&
   GetGlExtensions()
   {
      return gl_extensions;
   }

   inline const std::string&
   GetVendor()
   {
      return vendor;
   }

   inline const std::string&
   GetVersionString()
   {
      return gl_version;
   }
};

}// namespace system
}// namespace support
}// namespace leg

#endif
