/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: statereactor.h,v 1.3 2004/06/09 20:16:24 jd Exp $
   
   
   Created 06/01/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/states/statereactor.h
  \brief First support of states.
*/

#ifndef LEG_SUPPORT_STATES_STATE_REACTOR_H
#define LEG_SUPPORT_STATES_STATE_REACTOR_H

namespace leg
{
namespace support
{
namespace states
{

template 
<
   class Sync
> 
class BaseReactorPolicy
{
   Sync *mutex;
   
   public:
   
   BaseReactorPolicy ()
   {
   }

   protected:

   inline void
   SetStateMutex (Sync& state_mutex)
   {
      mutex = &state_mutex;
   }
};

//! Bridge to state reaction.
/*!
 * StateReactor is a bridge that links the state machine with the specified
 * state reaction policy.
 *
 * status:
 *    experimental.
 *
 * info:
 *    This class is not intended to be used like that.
 *
 * @sa StateMachine,HostInheritedStateMachine,StateActor,
 * DefaultStateReactorPolicy.
 */
template
<
   template <class,typename,class> class Policy,
   class Host,
   typename State,
   class Sync
>
class StateReactor: virtual private Policy<Host,State,Sync>
{
   protected:

   typedef Policy<Host,State,Sync> Parent;
   
   StateReactor (): Parent()
   {
   }

   ~StateReactor()
   {
   }

   void
   React (Host& host, State state)
   {
      Parent::React (host, state);
   }

   void
   SetStateMutex (Sync& mutex)
   {
      Parent::SetStateMutex (mutex);
   }
};

}
}
}
#endif
