/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: defaultstateactorpolicy.h,v 1.5 2004/06/09 20:16:24 jd Exp $
   
   
   Created 03/16/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/states/defaultstateactorpolicy.h
  \brief default policy for acting regarding inputs.
*/

#ifndef LEG_SUPPORT_STATES_DEFAULT_STATE_ACTOR_POLICY_H
#define LEG_SUPPORT_STATES_DEFAULT_STATE_ACTOR_POLICY_H

#include <iostream>

namespace leg
{
namespace support
{
namespace states
{

//! Default state action policy for state machine.
/*!
 * This class should be taken as a pure example, and has not to be used in any
 * real program. It shows the interface and eventual other things (member 
 * needs, inheritance...) to be provided by all the versions users will
 * implement.
 *
 * template arguments description:
 *    
 *    Input is the type of input (the same as the state machine).
 *
 *    State is the type of state (the same as the state machine).
 *
 *    Sync is the type of thread synchronization (the same as the state 
 *    machine). You should not inherit from the it into the policy, because
 *    this will create interferings between this class and the state machine.
 *
 * status:
 *    example only.
 *    This will disappear in a soon future.
 *
 * info:
 *    Has not to be used.
 */
template
<
   class Input,
   typename State,
   class Sync
>
class DefaultStateActorPolicy
{
   protected:

   Sync state_mutex;
   
   public:
   
   DefaultStateActorPolicy ()
   {
   }
   
   //! Act to an input.
   /*!
    * Manipulates a state regarding an input. state thread synchronization is 
    * let to the user's.
    */
   void
   Act (const Input& input, State& state)
   {
      state_mutex.Lock();
      std::cout << "Receive input: " << input << std::endl;
      if (input!="destruct"){
      }
      else{
	 state = 0;
	 std::cout << "state is set to zero !" << std::endl;
      }
      std::cout << "State is now " << state << " in Act()" << std::endl;
      state_mutex.Unlock();
   }

   inline Sync&
   GetStateMutex()
   {
      return state_mutex;
   }
};

}
}
}
#endif
