#ifndef LEG_SUPPORT_MODEL_MD2_IMPL_H
#define LEG_SUPPORT_MODEL_MD2_IMPL_H

namespace leg
{
namespace support
{
namespace model
{

const unsigned int MAX_FRAMES = 512;

// a single vertex
typedef struct
{
   float point[3];
} vector_t;

vector_t operator-(vector_t a, vector_t b);
vector_t operator*(float f, vector_t b);
vector_t operator/(vector_t a, vector_t b);
vector_t operator+(vector_t a, vector_t b);

// texture coordinate
typedef struct
{
   float s;
   float t;
} texCoord_t;

// data for a single triangle
typedef struct
{
   unsigned short meshIndex[3];		// vertex indices
   unsigned short stIndex[3];		// texture coordinate indices
} mesh_t;

class CMD2Model
{
   int numFrames;	   // number of model frames
   int numVertices;        // number of vertices
   int numTriangles;       // number of triangles
   int numST;              // number of skins
   int frameSize;          // size of each frame in bytes
   int currentFrame;       // current frame # in animation
   int nextFrame;          // next frame # in animation
   float interpol;         // percent through current frame
   mesh_t *triIndex;       // triangle list
   texCoord_t *st;         // texture coordinate list
   vector_t *vertexList;   // vertex list
//   texture_t *modelTex;    // texture data

//   void SetupSkin(texture_t *thisTexture);

   public:

   CMD2Model();
   
   ~CMD2Model();

   // load model and skin/texture at the same time
   int Load(const char *modelFile, const char *skinFile);

   // THIS ONE BELOW IS BUGGY !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   
   // load model only
   int LoadModel(const char *modelFile);

   // load skin only
//   int LoadSkin(char *skinFile);

   // set model's texture/skin
//   int SetTexture(texture_t *texture);

   // render model with interpolation to get animation
   int Animate(int startFrame, int endFrame, float percent);

   // free memory of model
   int Unload();

   private:

   friend class Md2Model;
};

}
}
}

#endif
