/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/format3ds.h
  \brief all support for models.

  Notes: this source code is a lot based on the sources the author
   made in a previous project.
*/

#ifndef LEG_SUPPORT_MODEL_FORMAT_3DS_H
#define LEG_SUPPORT_MODEL_FORMAT_3DS_H

#include "baseformatloader.h"
#include <lib3ds/file.h>
#include <lib3ds/node.h>

namespace leg
{
namespace support
{
namespace model
{

class Model;
class Meshes;

class Format3ds: public BaseFormatLoader
{
   Model *mdl;

   float min_v[3];
   float max_v[3];
   
   public:
   
   static const std::string extension;

   Format3ds();

   Format3ds (const Format3ds& v);

   ~Format3ds();

   // only supports model and not full map.
   // this alloacates a model and surely other data needed by it.
   Model&
   Load (const std::string& f);

   void
   Save (const std::string& filename, Model& mdl)
   {
      // not implemented !
   }
   
   BaseFormatLoader&
   Clone();
   
   protected:

   void
   Copy (const Format3ds& f);

   void
   ReadNodeInformation (Lib3dsNode *const node, Lib3dsFile *const file);

   void
   LoadByMesh (Lib3dsFile* file);

   void
   ReadMeshInformation (Lib3dsMesh *const mesh, Lib3dsFile *const file);
};

}
}
}

#endif
