/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $
   
   $Log: $

   Created 11/15/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file leg/support/maths/box.h
  \brief A class representing a box.
*/

#ifndef LEG_SUPPORT_MATHS_BOX_H
#define LEG_SUPPORT_MATHS_BOX_H

#include "vector.h"
#include <leg/support/maths/volume.h>
#include "leg/support/maths/quaternion.h"
#include <vector>

namespace leg
{
namespace support
{
namespace maths
{

class Box: public Volume
{
   typedef Point<3> Pt;
   
   std::vector<Pt> points;
   Pt	       center;
   real	       ridge; // arte

   public:

   // is defined with no rotations at all, so with each edges matching all the
   // axis of the vectorial space.
   Box (const Pt& c, real r): points (std::vector<Pt> (8)),
			      center (c),
			      ridge (r)
   {
   }
  
   ~Box();

   bool
   HitsPoint (const Point<3>& pt)
   {
      return false;
   }
  
   bool
   HitsLine (Line<3> line)
   {
      return false;
   }

   const Point<3>&
   GetCenter() const
   {
      return center;
   }

   real
   GetRidge ()
   {
      return ridge;
   }

   void
   Orientate (const Vector<3>& angles)
   {
      /*
      real r = ridge * .5;
      
      Vector<3> a (-r, -r, -r);
      Vector<3> b (r, -r, -r);
      Vector<3> c (r, -r, r);
      Vector<3> d (-r, -r, r);
	
      Vector<3> axis (0,1,0);
      Quaternion q (angles.x);

      a = q.Rotate (a);
      b = q.Rotate (b);
      c = q.Rotate (c);
      d = q.Rotate (d);

      a += center;
      b += center;
      c += center;
      d += center;
      
      points[0] = points[4] = a;
      points[1] = points[5] = b;
      points[2] = points[6] = c;
      points[3] = points[7] = d;
	
      points[4].y += r;
      points[5].y += r;
      points[6].y += r;
      points[7].y += r;
      */
   }

   Box*
   Clone()
   {
      return new Box (*this);
   }
};

}
}
}

#endif // LEG_SUPPORT_MATHS_BOX_H
