/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   $Log: $

   Created 03/31/05 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/snapshot.h
  \brief snapshots utilities
*/

#ifndef LEG_SUPPORT_GRAPHICS_SNAPSHOT_H
#define LEG_SUPPORT_GRAPHICS_SNAPSHOT_H

namespace leg
{
namespace support
{
namespace graphics
{

class Snap
{
   GLsizei  width;
   GLsizei  height;
   GLenum   format;
   GLenum   buffer;
   GLint    depth;
   char	    *data;
   
   public:

   Snap():  width (800),
	    height (600),
	    format (GL_BGR),
	    buffer (GL_FRONT),
	    depth (24),
	    data (0)
   {
   }

   virtual ~Snap()
   {
      if (data){
	 delete [] data;
	 data = 0;
      }
   }

   void
   ReadBuffer()
   {
      if (data){
	 delete [] data;
	 data = 0;
      }
      data = new char[3*width*size];
      
      glReadBuffer (buffer);
      glReadPixels (0, 0, width, height, format, GL_UNSIGNED_BYTE, data);
   }

   virtual void
   Save (std::string& filename) = 0;

   void
   Shot (std::string& filename)
   {
      ReadBuffer();
      Save (filename);
   }
};

class SnapTga: public Snap
{
   public:

   void
   Save (std::string& filename)
   {
      short TGAhead[] = {0, 2, 0, 0, 0, 0, width, height, depth};
      FILE *out = std::fopen (filename.c_str(), "w");
      std::fwrite (&TGAhead, sizeof(TGAhead), 1, out);
      std::fwrite (data, 3*width*height, 1, out);
      std::fclose (out);
   }
};
   
}
}
}

#endif // LEG_SUPPORT_GRAPHICS_SNAPSHOT_H
