/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glerror.h,v 1.1 2004/05/06 22:08:00 jd Exp $
   $Log: glerror.h,v $
   Revision 1.1  2004/05/06 22:08:00  jd
   first gl error release



   Created 03/22/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/glerror.h
  \brief Support for GL error handlings.
*/

#ifndef LEG_SUPPORT_GRAPHICS_GLERROR_H
#define LEG_SUPPORT_GRAPHICS_GLERROR_H

#include "leg/support/utils/issue.h"
#include <GL/gl.h>

namespace leg
{
namespace support
{
namespace graphics
{

//! Support for GL error handlings.
/*!
 * Support for GL error handlings.
 * Please have a look at the Issue documentation for details
 * about how things work.
 *
 * @sa Error, Issue
 *
 * status:
 *    undefined.
 *
 * info:
 *    none.
 */
class GLError: public support::utils::Issue
{
   private:

   GLError ();					// do not have to be implemented.
   GLError (const GLError&);			// idem.
   const GLError& operator = (const GLError&);	// idem.
   
   public:
   
   GLError (GLenum gl_err);
   
   GLError (GLenum gl_err, const std::string& msg);
   
   GLError (GLenum gl_err, const std::string& msg, const std::string& location);

   private:
   
   void
   OutGL (GLenum gl_err);
};

}
}
}
#endif
