/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: displaylist.h,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: displaylist.h,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.


   Created 4/21/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file displaylist.h
  \brief Support for OpenGL display lists.
*/

#ifndef LEG_SUPPORT_GRAPHICS_DISPLAYLIST_H
#define LEG_SUPPORT_GRAPHICS_DISPLAYLIST_H

#include <string>
#include <GL/gl.h>

namespace leg
{
namespace support
{
namespace graphics
{

class DisplayList
{
public:
  DisplayList ()
    : tag(glGenLists (1))
    {
    }

  ~DisplayList ()
    {
      glDeleteLists (tag, 1);
    }

  //! Begins compiling commands into the display list.
  /*! If execute is true, the commands are executed as well as
   * compiled.
   */
  void Compile (bool execute = false);

  //! Stop compiling.
  void Finish ();

  //! Run the commands stored in the display list.
  void operator () ();

 private:
  GLuint tag;
};

}
}
}

#endif // LEG_SUPPORT_GRAPHICS_DISPLAYLIST_H
