/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: window.h,v 1.3 2004/06/15 12:56:45 jd Exp $

   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file leg/libs/window/window.h
  \brief windowing libs.
*/

#ifndef LEG_LIBS_WINDOW_WINDOW_H
#define LEG_LIBS_WINDOW_WINDOW_H

#include "leg/support/window/window.h"
#include "defaultwindowingpolicy.h"
#include "defaulteventpolicy.h"
#include "genericwindow.h"
#include "osd.h"

namespace leg
{
namespace libs
{

//! Second layer for windowing,
/*!
 * Windowing manipulation.
 */
namespace window
{

// Events are no more used inside libs for the moment, with prefering including
// them in interactivity... to be seen
//typedef support::window::Event Event;
   
//! Window viewed threw the 2nd layer.
/*!
 * A generic, ready to use, configurable window.
 *
 * status:
 *    in progress.
 *
 * info:
 *    none.
 *
 * @sa GenericWindow
 */
template
<
   class Win = GenericWindow< DefaultWindowingPolicy,
			      leg::support::window::OSWindow,
			      leg::support::window::AbstractWindow,
			      leg::support::window::DisplayConnect> 
> 
class Window:  public Win
{
   Window();
   Window (const Window&);
   const Window& operator = (const Window&);
   
   public:
   
   explicit Window (leg::support::window::DisplayConnect& dc):  Win (dc)
   {
   }

   ~Window()
   {
   }
};

}
}
}
#endif
