/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file leg/libs/window/states.h
  \brief default states for libs::window.
*/

#ifndef LEG_LIBS_WINDOW_STATES_H
#define LEG_LIBS_WINDOW_STATES_H

namespace leg
{
namespace libs
{
namespace window
{

typedef unsigned int State;

//! All the states the window could be in.
namespace state
{
   using leg::libs::window::State;
   
   static const State destructed       = 0x0;
   static const State constructed      = 0x1;
   static const State configured       = 0x2;
   static const State created	       = 0x4;
   static const State drawable	       = 0x8;
   static const State drawing	       = 0x10;
   static const State sized	       = 0x20;
   static const State fullscreen       = 0x40;
   static const State window	       = 0x80;
   static const State paused	       = 0x100;
   static const State locked	       = 0x200;
   static const State drawable_locked  = 0x400;
   static const State hud_drawable     = 0x800;
   static const State hud_drawing      = 0x1000;
}
}
}
}
#endif
