/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: genericwindow.h,v 1.4 2004/06/15 12:56:45 jd Exp $

   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/window/genericwindow.h
  \brief full generic useable window.
*/

#ifndef LEG_LIBS_WINDOW_GENERIC_WINDOW_H
#define LEG_LIBS_WINDOW_GENERIC_WINDOW_H

namespace leg
{
namespace libs
{
namespace window
{

//! Full generic policy based class designed configurable window.
/*!
 * This window is a false layer of support::Window, but could in reality be an
 * inherited class of support::Window if templates are specified for. In this
 * case, polymorphism will be useable quiete easily. But you may simply use
 * this concrete type for avoiding vtable accesses and to be able to take 
 * profit from all the providen functionalities.
 *
 * template arguments description:
 *
 *    WindowingPolicy describes the windowing policy used (generally this will
 *    be DefaultWindowingPolicy).
 *
 *    HW represents the 'hardware' window that will generally be 
 *    leg::support::window::OSWindow.
 *
 *    AbstractType represents the abstract type (the interface) for the window
 *    to fulfill first: leg::support::window::AbstractWindow generally.
 *
 *    Connection is the base type of the graphic server connection.
 *
 * status:
 * 	in progress.
 *
 * info:
 * 	Thread synchronization and state managements must be done inside the
 * 	windowing policy. So, try to use the default providen one.
 *
 * @sa leg::support::window::Window, leg::libs::window::Window, 
 *    DefaultWindowingPolicy, AbstractWindow, OSWindow.
 */
template
<
   template <class,class> class WindowingPolicy,
   class HW,
   template <class> class AbstractType,
   class Connection
>
class GenericWindow: public WindowingPolicy<AbstractType<HW>,Connection>
{
   protected:

   GenericWindow (const GenericWindow&);

   const GenericWindow& operator = (const GenericWindow&);

   typedef WindowingPolicy<AbstractType<HW>,Connection>	 ParentType;

   public:

   typedef typename ParentType::Attr			 Attributes;
   typedef typename ParentType::Drawable		 Drawable;
   typedef WindowingPolicy<AbstractType<HW>,Connection>	 StateMachine;


   // connection needs to be opened before.
   explicit GenericWindow (Connection& connection)  : ParentType (connection)
   {
   }

   ~GenericWindow ()
   {
   }
};

}
}
}
#endif
