/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: timing-class.h,v 1.1 2004/05/13 04:16:02 jechk Exp $
   $Log: timing-class.h,v $
   Revision 1.1  2004/05/13 04:16:02  jechk
   Split timing into two parts; moved message to libs.



   Created 5/12/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/timing/timing-class.h
  \brief A timing class with added support for timers.
*/

#include <leg/support/timing/timing.h>

#ifndef LEG_LIBS_TIMING_TIMINGCLASS_H
#define LEG_LIBS_TIMING_TIMINGCLASS_H

namespace leg
{

namespace libs
{

namespace timing
{

class Timer;
class Timing : public support::timing::Timing
{
public:
  Timing (double units_per_sec = 1., support::timing::game_time current_time = 0.);

private:

  class TimerThread: public support::threads::Thread
  {
  public:
    TimerThread ();

    // Adds a new timer to the list.
    void AddTimer (Timer *timer);

    // Removes a timer from the list.
    void RemoveTimer (Timer *timer);
    
    // Called in the new thread.
    void *Go (void *args = NULL);

  private:
    std::list<Timer *> timers;
  };

  // Thread that handles timers.
  TimerThread thread;

  friend class Timer;
};

}

}

}

#endif // LEG_LIBS_TIMING_TIMINGCLASS_H
