/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: threader.h,v 1.2 2004/06/03 23:03:23 jd Exp $

   $Log: threader.h,v $
   Revision 1.2  2004/06/03 23:03:23  jd
   better support with independant state synchronization, and dispatching into files

   Revision 1.1  2004/05/31 20:40:56  jd
   first release


 
   Created 05/21/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/threads/threader.h
  \brief threaders.
*/

#ifndef LEG_LIBS_THREADS_THREADER_H
#define LEG_LIBS_THREADS_THREADER_H

#include "leg/support/threads/thread.h"
#include "sync.h"

namespace leg
{
namespace libs
{
namespace threads
{

//! A simple threader
/*!
 * A threader is a thread that has sync and condition capabilities.
 * This is not intended to be directly used.
 *
 * status:
 *    in progress.
 *
 * info:
 *    none.
 */
template
<
   class TThread = leg::support::threads::Thread,
   class TSync = Sync<>,
   class TCond = Cond<>
>
struct Threader : public TThread,
		  public TSync,
		  public TCond
{
   using TCond::Wait;
   using TCond::Signal;
   
   Threader(): TThread(), 
	       TSync(),
	       TCond()
   {
   }
   
   ~Threader()
   {
   }
   
   private:
   
   Threader (const Threader&);
   const Threader& operator = (const Threader&);
};

}
}
}
#endif
