/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: threadablecell.h,v 1.3 2004/06/03 23:03:23 jd Exp $
 
   Created 05/21/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/threads/threadablecell.h
  \brief threadable cell with sync.
*/

#ifndef LEG_LIBS_THREADS_THREADABLE_CELL_H
#define LEG_LIBS_THREADS_THREADABLE_CELL_H

#include "sync.h"

namespace leg
{
namespace libs
{
namespace threads
{

//! A cell that could be threaded.
/*!
 * A not threaded but synchronized class inherited from the cell.
 *
 * status:
 *    in progress.
 *
 * info:
 *    not intended for users.
 */
template
<
   template <class> class Cell,
   class TSync = Sync<>
>
class ThreadableCell : public Cell<TSync>
{
   protected:

   typedef TSync MutexType;

   typedef Cell<TSync> Parent;

   ThreadableCell (): Cell<TSync> ()
   {
   }

   ThreadableCell (ThreadableCell<Cell,TSync>& sync_cell):  Cell<TSync> (sync_cell)
   {
   }
   
   ~ThreadableCell()
   {
   }

   inline Cell<TSync>&
   GetCell ()
   {
      return *this;
   }
};

}
}
}
#endif
