/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 03/28/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/scene/simplecamera.h
  \brief A simple camera.
*/

#ifndef LEG_LIBS_SCENE_SIMPLE_CAMERA_H
#define LEG_LIBS_SCENE_SIMPLE_CAMERA_H

#include "camera.h"

namespace leg
{
namespace libs
{
namespace scene
{

class SimpleCamera: public Camera
{
   public:
   
   //
   // ! WARNING !
   //
   // You MUST redefine those two declarations for each class you will inherit
   // in this hierarchy. You also MUST to assign them with the appropriate 
   // values. Otherwise, expect data corruption on loading and saving.
   // 
   
   static const std::string main_id;
   static const std::string sub_id;

   SimpleCamera();
      
   SimpleCamera (const SimpleCamera& c);

   void
   Init();

   void
   Update();

   SimpleCamera*
   Clone();

   void
   Read (std::ifstream& ifs);

   void
   Write (std::ofstream& ofs);

   const std::string
   GetMainId()
   {
      return main_id;
   }

   const std::string
   GetSubId()
   {
      return sub_id;
   }

   const Entity::Propriety
   GetPropriety() const;

   protected:

   void
   Copy (const SimpleCamera& c);
};

class TargetedCamera: public SimpleCamera
{
   Vector   *target;
};

}
}
}

#endif // LEG_LIBS_SCENE_SIMPLE_CAMERA_H
