/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 03/28/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/scene/pointlight.h
  \brief Point lights.
*/

#ifndef LEG_LIBS_SCENE_POINT_LIGHT_H
#define LEG_LIBS_SCENE_POINT_LIGHT_H

#include "light.h"

namespace leg
{
namespace libs
{
namespace scene
{

class PointLight: public Light
{
   typedef Light Parent;
   
   public:
   
   //
   // ! WARNING !
   //
   // You MUST redefine those two declarations for each class you will inherit
   // in this hierarchy. You also MUST to assign them with the appropriate 
   // values. Otherwise, expect data corruption on loading and saving.
   // 
   
   static const std::string main_id;
   static const std::string sub_id;

   PointLight();

   PointLight (const PointLight& c);

   const PointLight&
   operator = (const PointLight& c);

   void
   Read (std::ifstream& ifs);

   void
   Write (std::ofstream& ofs);

   const std::string
   GetMainId();

   const std::string
   GetSubId();

   void
   Init();

   void
   Update();

   PointLight*
   Clone();

   const Entity::Propriety
   GetPropriety() const;

   protected:
   
   inline void
   Copy (const PointLight& c);
};

}
}
}

#endif // LEG_LIBS_SCENE_LIGHT_H
