/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/27/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/message/deliverer.h
  \brief Post-Office messages delivering.
*/

#ifndef LEG_LIBS_MESSAGE_DELIVERER_H
#define LEG_LIBS_MESSAGE_DELIVERER_H

#include "common.h"
#include "basedeliverer.h"

namespace leg
{
namespace libs
{
namespace message
{

//! Message delivering template class.
/*!
 * Deliver messages to the destination object.
 * 
 * status:
 *    not fitting the design: surely a bug:
 *    When making a specialization of this class in the test program, within the
 *    good namespace (leg::libs::message), this is this default template Deliver
 *    member function that is called instead of the specialized one. So the
 *    Deliver function cannot be specialized for each type correctly. It must 
 *    then call to the destination object member function Receive.
 *
 * info:
 *    none.
 *
 * @sa BaseDeliver,PostOffice.
 */
template
<
   class To
>
class Deliverer: public BaseDeliverer
{
   To& to;

   Deliverer();
   
   public:

   explicit Deliverer (To& t):BaseDeliverer(),
			      to (t)
   {
   }

   Deliverer (const Deliverer& d):  BaseDeliverer (static_cast<const BaseDeliverer&> (d)),
				    to (d.to)
   {
   }

   ~Deliverer()
   {
   }

   const Deliverer&
   operator = (const Deliverer& d)
   {
      to = d.to; // huh

      return *this;
   }

   BaseDeliverer&
   Clone()
   {
      return *new Deliverer<To> (to);
   }

   void
   Deliver (const Message& msg)
   {
      to.ReceiveMessage (msg);
   }

   protected:

   void
   Copy (const Deliverer&)
   {
   }
};

}
}
}

#endif
