/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: controler.h,v 1.2 2004/06/19 11:14:48 jd Exp $

   Created 04/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/interactivity/controler.h
  \brief base class for user controlers (as mouse and keyboard)
*/

#ifndef LEG_LIBS_INTERACTIVITY_CONTROLER_H
#define LEG_LIBS_INTERACTIVITY_CONTROLER_H

#include "leg/support/timing/timing.h"

namespace leg
{
namespace libs
{
namespace interactivity
{

typedef leg::support::timing::game_time	  GameTime;

//! Interactivity controler base class.
/*!
 * Base class of a user controlers hierarchy. Any such said controlers could be
 * a mouse, a keyboard, a joypad or any others and should inherit from it.
 * Even if polymorphism is enabled, current development is more oriented on 
 * each static type of the childhood simply just because two kind of controlers
 * could be very different.
 *
 * Any controler will need to be linked with the window event, so that they can
 * communicate with it quiete easily. But this is well only for window-
 * dependant controler (just keyboard and mouse), not joypads...
 * 
 * status:
 *    in development.
 *
 * info:
 *    none.
 *
 * @sa Keyboard,Mouse,leg::support::window::Event.
 *
 * TODO:
 *    * Keyboard and mouse should directly take new events from event instead
 *    of going threw each key/button in their map: it will be so faster !
 *    * Keyboard and Mouse should inherit from a common class between them and
 *    this Controler class, that might be called SimpleControler. And there
 *    also might have a WindowControler inheriting from SimpleControler.
 */
class Controler
{
   Controler (const Controler&);
   const Controler& operator = (const Controler&);

   protected:

   //! constructor that no more requires a user-event.
   /*!
    * New:
    * Controlers won't need any event anymore, but one should be initializes
    * with Init (...) to be useable.
    */
   Controler();

   public:

   virtual ~Controler();
};

}
}
}
#endif
