#!/bin/sh

function make_conf
{
   echo "Running aclocal."
   aclocal
   echo "Running automake."
   automake
   echo "Running autoconf."
   autoconf
   echo "You can now run './configure' to begin build configuration."
}

function make_libtool
{
   echo "Forcing new libtool files."
   libtoolize --automake --force
}

echo ""
echo "Libraries and Engines for Games"
echo "GNU/Leg (c) 2004-2005 Free Software Foundation."
echo "GNU/Leg authors are:"
echo "Jeff Binder	      <bindej@rpi.edu>"
echo "Jean-Dominique Frattini <zionarea@free.fr>"
echo ""
echo "This program is provided with no warranty at all."
echo "Read the license before using this program."
echo ""
echo "Welcome to GNU/Leg configuration."
echo ""
echo "Working (this could take a moment)"

if [ $# = 0 ] ; then
   make_conf
else
   make_libtool
   make_conf
fi

