/*1:*/
#line 19 "libjpt/memtable.x"
#include <assert.h>
#include <errno.h>
#include <pthread.h>
#include <string.h>

#include "jpt_internal.h"/*2:*/
#line 39 "libjpt/memtable.x"
static void
JPT_memtable_list_all_right(struct JPT_node*n,struct JPT_node* * *nodes);

static void
JPT_memtable_list_all_left(struct JPT_node*n,struct JPT_node* * *nodes)
{
struct JPT_node*top=n->parent;

while(n->left)
n=n->left;

while(n!=top)
{/*4:*/
#line 146 "libjpt/memtable.x"
if(n->data.value!=(void*)-1)
{
* *nodes=n;
++(*nodes);
}/*:4*/
#line 54 "libjpt/memtable.x"
if(n->right)
JPT_memtable_list_all_right(n->right,nodes);

n=n->parent;
}
}

static void
JPT_memtable_list_all_right(struct JPT_node*n,struct JPT_node* * *nodes)
{
while(n)
{
if(n->left)
JPT_memtable_list_all_left(n->left,nodes);/*4:*/
#line 146 "libjpt/memtable.x"
if(n->data.value!=(void*)-1)
{
* *nodes=n;
++(*nodes);
}/*:4*/
#line 71 "libjpt/memtable.x"
n=n->right;
}
}

void
JPT_memtable_list_all(struct JPT_info*info,struct JPT_node* * *nodes)
{
pthread_rwlock_rdlock(&info->splay_lock);

if(info->root)
JPT_memtable_list_all_left(info->root,nodes);

pthread_rwlock_unlock(&info->splay_lock);
}/*:2*//*3:*/
#line 91 "libjpt/memtable.x"
static void
JPT_memtable_list_column_right(struct JPT_node*n,struct JPT_node* * *nodes,
uint32_t columnidx);

static void
JPT_memtable_list_column_left(struct JPT_node*n,struct JPT_node* * *nodes,uint32_t columnidx)
{
struct JPT_node*top=n->parent;

while(n->left&&n->columnidx>=columnidx)
n=n->left;

while(n!=top)
{/*5:*/
#line 156 "libjpt/memtable.x"
if(n->columnidx==columnidx&&n->data.value!=(void*)-1)
{
* *nodes=n;
++(*nodes);
}/*:5*/
#line 107 "libjpt/memtable.x"
if(n->right)
JPT_memtable_list_column_right(n->right,nodes,columnidx);

n=n->parent;
}
}

static void
JPT_memtable_list_column_right(struct JPT_node*n,struct JPT_node* * *nodes,uint32_t columnidx)
{
while(n)
{
if(n->left)
JPT_memtable_list_column_left(n->left,nodes,columnidx);/*5:*/
#line 156 "libjpt/memtable.x"
if(n->columnidx==columnidx&&n->data.value!=(void*)-1)
{
* *nodes=n;
++(*nodes);
}/*:5*/
#line 124 "libjpt/memtable.x"
if(n->columnidx>columnidx)
return;

n=n->right;
}
}

void
JPT_memtable_list_column(struct JPT_info*info,struct JPT_node* * *nodes,uint32_t columnidx)
{
pthread_rwlock_rdlock(&info->splay_lock);

if(info->root)
JPT_memtable_list_column_left(info->root,nodes,columnidx);

pthread_rwlock_unlock(&info->splay_lock);
}/*:3*//*9:*/
#line 195 "libjpt/memtable.x"
int
JPT_memtable_has_key(struct JPT_info*info,const char*row,uint32_t columnidx)
{
struct JPT_node*n;
int cmp;

pthread_rwlock_rdlock(&info->splay_lock);

n=info->root;

while(n)
{/*6:*/
#line 169 "libjpt/memtable.x"
if(columnidx!=n->columnidx)
cmp=columnidx-n->columnidx;
else
cmp=strcmp(row,n->row);/*:6*//*7:*/
#line 178 "libjpt/memtable.x"
if(cmp<0)/*:7*/
#line 210 "libjpt/memtable.x"
{
n=n->left;

continue;
}/*8:*/
#line 184 "libjpt/memtable.x"
if(cmp>0)/*:8*/
#line 217 "libjpt/memtable.x"
{
n=n->right;

continue;
}

pthread_rwlock_unlock(&info->splay_lock);

if(0==pthread_rwlock_trywrlock(&info->splay_lock))
{
JPT_memtable_splay(info,n);

pthread_rwlock_unlock(&info->splay_lock);
}

if(n->data.value==(void*)-1)
break;

return 0;
}

pthread_rwlock_unlock(&info->splay_lock);

return-1;
}/*:9*//*10:*/
#line 248 "libjpt/memtable.x"
int
JPT_memtable_get(struct JPT_info*info,const char*row,uint32_t columnidx,
void* *value,size_t*value_size,size_t*skip,size_t*max_read,
uint64_t*timestamp)
{
struct JPT_node*n;
int cmp;

pthread_rwlock_rdlock(&info->splay_lock);

n=info->root;

while(n)
{
struct JPT_node_data*d;
size_t i;/*6:*/
#line 169 "libjpt/memtable.x"
if(columnidx!=n->columnidx)
cmp=columnidx-n->columnidx;
else
cmp=strcmp(row,n->row);/*:6*//*7:*/
#line 178 "libjpt/memtable.x"
if(cmp<0)/*:7*/
#line 268 "libjpt/memtable.x"
{
n=n->left;

continue;
}/*8:*/
#line 184 "libjpt/memtable.x"
if(cmp>0)/*:8*/
#line 275 "libjpt/memtable.x"
{
n=n->right;

continue;
}/*11:*/
#line 305 "libjpt/memtable.x"
if(n->data.value==(void*)-1)
break;

i= *value_size;/*14:*/
#line 365 "libjpt/memtable.x"
d= &n->data;

do
{
*value_size+=d->value_size;
d=d->next;
}
while(d);/*:14*/
#line 312 "libjpt/memtable.x"
if(max_read)
{/*12:*/
#line 330 "libjpt/memtable.x"
size_t amount;

if(*value_size> *max_read)
*value_size= *max_read;

for(d= &n->data;i< *value_size;d=d->next)
{
if(i+d->value_size<= *value_size)
amount=d->value_size;
else
amount= *value_size-d->value_size;

memcpy(((char*)*value)+i,d->value,d->value_size);
i+=amount;
}/*:12*/
#line 315 "libjpt/memtable.x"
}
else
{/*13:*/
#line 352 "libjpt/memtable.x"
*value=realloc(*value,*value_size+1);

for(d= &n->data;i< *value_size;d=d->next)
{
memcpy(((char*)*value)+i,d->value,d->value_size);
i+=d->value_size;
}/*:13*/
#line 319 "libjpt/memtable.x"
}

if(timestamp)
*timestamp=n->timestamp;/*:11*/
#line 283 "libjpt/memtable.x"
pthread_rwlock_unlock(&info->splay_lock);

if(0==pthread_rwlock_trywrlock(&info->splay_lock))
{
JPT_memtable_splay(info,n);

pthread_rwlock_unlock(&info->splay_lock);
}

return 0;
}

pthread_rwlock_unlock(&info->splay_lock);

return-1;
}/*:10*//*15:*/
#line 381 "libjpt/memtable.x"
#define UPDATE_LINK(node,leg,child)\
do\
{\
(node)->leg=(child);\
if(child)\
(child)->parent=(node);\
}\
while(0)

void
JPT_memtable_splay(struct JPT_info*info,struct JPT_node*n)
{
while(n->parent)
{
struct JPT_node*parent=n->parent;
int is_left_child=(n==parent->left);

assert(is_left_child^(n==parent->right));

if(!parent->parent)
{/*16:*/
#line 437 "libjpt/memtable.x"
assert(parent==info->root);

if(is_left_child)
{
UPDATE_LINK(parent,left,n->right);
UPDATE_LINK(n,right,parent);

info->root=n;
n->parent=0;
}
else
{
UPDATE_LINK(parent,right,n->left);
UPDATE_LINK(n,left,parent);

info->root=n;
n->parent=0;
}/*:16*/
#line 404 "libjpt/memtable.x"
break;
}
else
{
struct JPT_node*gparent=parent->parent;
int parent_is_left_child=(parent==gparent->left);/*17:*/
#line 461 "libjpt/memtable.x"
if(gparent->parent)
{
if(gparent->parent->left==gparent)
{
gparent->parent->left=n;
}
else
{
assert(gparent->parent->right==gparent);

gparent->parent->right=n;
}

n->parent=gparent->parent;
}
else
{
info->root=n;

n->parent=0;
}/*:17*/
#line 413 "libjpt/memtable.x"
if(is_left_child==parent_is_left_child)
{/*18:*/
#line 498 "libjpt/memtable.x"
if(is_left_child)
{
UPDATE_LINK(gparent,left,parent->right);
UPDATE_LINK(parent,left,n->right);
UPDATE_LINK(parent,right,gparent);
UPDATE_LINK(n,right,parent);
}
else
{
UPDATE_LINK(gparent,right,parent->left);
UPDATE_LINK(parent,right,n->left);
UPDATE_LINK(parent,left,gparent);
UPDATE_LINK(n,left,parent);
}/*:18*/
#line 416 "libjpt/memtable.x"
}
else
{/*19:*/
#line 528 "libjpt/memtable.x"
if(!is_left_child)
{
UPDATE_LINK(gparent,left,n->right);
UPDATE_LINK(parent,right,n->left);
UPDATE_LINK(n,left,parent);
UPDATE_LINK(n,right,gparent);
}
else
{
UPDATE_LINK(gparent,right,n->left);
UPDATE_LINK(parent,left,n->right);
UPDATE_LINK(n,right,parent);
UPDATE_LINK(n,left,gparent);
}/*:19*/
#line 420 "libjpt/memtable.x"
}
}
}
}/*:15*//*20:*/
#line 551 "libjpt/memtable.x"
static void*
JPT_memtable_buffer_alloc(struct JPT_info*info,size_t size)
{
void*result;

if(!info->buffer)
{
info->buffer=malloc(info->buffer_size);

if(!info->buffer)
{
asprintf(&JPT_last_error,
"Failed to allocate %zu bytes for memtable: %s",
info->buffer_size,strerror(errno));

return 0;
}
}

result=info->buffer+info->buffer_util;
info->buffer_util=(info->buffer_util+size+3)&~3;

assert(info->buffer_util<=info->buffer_size);

return result;
}/*:20*//*21:*/
#line 589 "libjpt/memtable.x"
static struct JPT_node*
JPT_memtable_create_node(struct JPT_info*info,
const void*row,uint32_t columnidx,
const void*value,size_t value_size,
int will_compact)
{
struct JPT_node*result;

result=JPT_memtable_buffer_alloc(info,sizeof(struct JPT_node));
result->row=JPT_memtable_buffer_alloc(info,strlen(row)+1);
result->data.value_size=value_size;
result->data.next=0;
result->parent=0;
result->left=0;
result->right=0;
result->last=0;
result->columnidx=columnidx;

strcpy(result->row,row);

if(will_compact)
result->data.value=(char*)value;
else
{
result->data.value=JPT_memtable_buffer_alloc(info,value_size);
memcpy(result->data.value,value,value_size);
}

return result;
}/*:21*//*22:*/
#line 631 "libjpt/memtable.x"
int
JPT_memtable_insert(struct JPT_info*info,const char*row,uint32_t columnidx,
const void*value,size_t value_size,uint64_t*timestamp,
int flags)
{
struct JPT_node*n;
size_t space_needed;
size_t row_size=strlen(row)+1;
int must_compact=0;
int cmp;/*23:*/
#line 739 "libjpt/memtable.x"
space_needed=((row_size+3)&~3)
+((sizeof(struct JPT_node)+3)&~3);

if(info->buffer_util+space_needed>info->buffer_size)
{
if(!(flags&(JPT_REPLACE|JPT_APPEND))&&0==JPT_memtable_has_key(info,row,columnidx))
{
errno=EEXIST;

return-1;
}
else if(flags&JPT_REPLACE)
JPT_memtable_remove(info,row,columnidx);

if(-1==JPT_compact(info))
return-1;
}

assert(info->buffer_util+space_needed<=info->buffer_size);

space_needed+=((value_size+3)&~3);

if(info->buffer_util+space_needed>info->buffer_size)
must_compact=1;/*:23*//*24:*/
#line 766 "libjpt/memtable.x"
if(!info->root)
{
assert(!info->node_count);
assert(!info->memtable_key_count);
assert(!info->memtable_key_size);
assert(!info->memtable_value_size);

info->root=JPT_memtable_create_node(info,row,columnidx,value,value_size,must_compact);
info->root->timestamp= *timestamp;
info->node_count=1;
info->memtable_key_count=1;
info->memtable_key_size=strlen(row)+1;
info->memtable_value_size=value_size;

goto done;
}/*:24*/
#line 645 "libjpt/memtable.x"
n=info->root;

for(;;)
{/*6:*/
#line 169 "libjpt/memtable.x"
if(columnidx!=n->columnidx)
cmp=columnidx-n->columnidx;
else
cmp=strcmp(row,n->row);/*:6*//*7:*/
#line 178 "libjpt/memtable.x"
if(cmp<0)/*:7*/
#line 652 "libjpt/memtable.x"
{
if(!n->left)
{
n->left=JPT_memtable_create_node(info,row,columnidx,value,
value_size,must_compact);
n->left->timestamp= *timestamp;
n->left->parent=n;
++info->node_count;
++info->memtable_key_count;
info->memtable_key_size+=strlen(row)+1;
info->memtable_value_size+=value_size;

JPT_memtable_splay(info,n->left);

break;
}

n=n->left;

continue;
}/*8:*/
#line 184 "libjpt/memtable.x"
if(cmp>0)/*:8*/
#line 675 "libjpt/memtable.x"
{
if(!n->right)
{
n->right=JPT_memtable_create_node(info,row,columnidx,value,
value_size,must_compact);
n->right->timestamp= *timestamp;
n->right->parent=n;
++info->node_count;
++info->memtable_key_count;
info->memtable_key_size+=strlen(row)+1;
info->memtable_value_size+=value_size;

JPT_memtable_splay(info,n->right);

break;
}

n=n->right;

continue;
}

if(n->data.value==(void*)-1)
{/*25:*/
#line 788 "libjpt/memtable.x"
if(must_compact)
n->data.value=(char*)value;
else
{
n->data.value=JPT_memtable_buffer_alloc(info,value_size);
memcpy(n->data.value,value,value_size);
}

n->timestamp= *timestamp;
n->data.value_size=value_size;
n->data.next=0;
n->last=0;

info->memtable_value_size+=value_size;
info->memtable_key_size+=strlen(row)+1;
++info->node_count;
++info->memtable_key_count;/*:25*/
#line 700 "libjpt/memtable.x"
}
else if(flags&JPT_APPEND)
{/*26:*/
#line 811 "libjpt/memtable.x"
struct JPT_node_data*d=JPT_memtable_buffer_alloc(info,sizeof(struct JPT_node_data));

if(!n->last)
{
n->data.next=d;
n->last=d;
}
else
{
assert(!n->last->next);
n->last->next=d;
n->last=d;
}

if(must_compact)
d->value=(char*)value;
else
{
d->value=JPT_memtable_buffer_alloc(info,value_size);
memcpy(d->value,value,value_size);
}

n->timestamp= *timestamp;
d->value_size=value_size;
d->next=0;

info->memtable_value_size+=value_size;/*:26*/
#line 704 "libjpt/memtable.x"
}
else if(flags&JPT_REPLACE)
{/*27:*/
#line 844 "libjpt/memtable.x"
struct JPT_node_data*d;

d= &n->data;/*28:*/
#line 903 "libjpt/memtable.x"
if(d->value_size>=value_size)
{
info->memtable_value_size-=d->value_size;
info->memtable_value_size+=value_size;
d->value_size=value_size;
}/*:28*//*29:*/
#line 912 "libjpt/memtable.x"
memcpy(d->value,value,d->value_size);

value=(char*)value+d->value_size;
value_size-=d->value_size;/*:29*/
#line 851 "libjpt/memtable.x"
n->last=0;
d=d->next;

while(d&&value_size)
{/*28:*/
#line 903 "libjpt/memtable.x"
if(d->value_size>=value_size)
{
info->memtable_value_size-=d->value_size;
info->memtable_value_size+=value_size;
d->value_size=value_size;
}/*:28*//*29:*/
#line 912 "libjpt/memtable.x"
memcpy(d->value,value,d->value_size);

value=(char*)value+d->value_size;
value_size-=d->value_size;/*:29*/
#line 859 "libjpt/memtable.x"
n->last=d;
d=d->next;
}/*31:*/
#line 979 "libjpt/memtable.x"
while(d)
{
info->memtable_value_size-=d->value_size;

d=d->next;
}/*:31*/
#line 865 "libjpt/memtable.x"
if(!n->last)
n->data.next=0;

if(value_size)
{
d=JPT_memtable_buffer_alloc(info,sizeof(struct JPT_node_data));

if(must_compact)
d->value=(char*)value;
else
{
d->value=JPT_memtable_buffer_alloc(info,value_size);
memcpy(d->value,value,value_size);
}

d->value_size=value_size;
d->next=0;

info->memtable_value_size+=value_size;

if(n->data.next)
{
n->last->next=d;
n->last=d;
}
else
{
n->data.next=d;
n->last=d;
}
}
else if(n->last)
n->last->next=0;

n->timestamp= *timestamp;/*:27*/
#line 708 "libjpt/memtable.x"
}
else
{
JPT_memtable_splay(info,n);

errno=EEXIST;

return-1;
}

JPT_memtable_splay(info,n);

break;
}

done:

if(must_compact)
{
if(-1==JPT_compact(info))
return-1;


return 1;
}

return 0;
}/*:22*//*30:*/
#line 923 "libjpt/memtable.x"
int
JPT_memtable_remove(struct JPT_info*info,const char*row,uint32_t columnidx)
{
struct JPT_node*n;

n=info->root;

while(n)
{
int cmp;/*6:*/
#line 169 "libjpt/memtable.x"
if(columnidx!=n->columnidx)
cmp=columnidx-n->columnidx;
else
cmp=strcmp(row,n->row);/*:6*//*7:*/
#line 178 "libjpt/memtable.x"
if(cmp<0)/*:7*/
#line 937 "libjpt/memtable.x"
{
n=n->left;

continue;
}/*8:*/
#line 184 "libjpt/memtable.x"
if(cmp>0)/*:8*/
#line 944 "libjpt/memtable.x"
{
n=n->right;

continue;
}

if(n->data.value!=(void*)-1)
{
struct JPT_node_data*d= &n->data;/*31:*/
#line 979 "libjpt/memtable.x"
while(d)
{
info->memtable_value_size-=d->value_size;

d=d->next;
}/*:31*/
#line 956 "libjpt/memtable.x"
info->memtable_key_size-=strlen(row)+1;
--info->memtable_key_count;
--info->node_count;

n->data.value=(void*)-1;
n->data.next=0;

return 0;
}

return-1;
}

return-1;
}/*:30*//*:1*/
