/* CharToInt.java - Copyright (c) 2005 by Stefan Thesing
 <p>This file is part of Webdings Tools.</p>
 <p>Webdings Tools is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.</p>
<p>Webdings Tools is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.</p>
<p>You should have received a copy of the GNU General Public License
along with Webdings Tools; if not, write to the<br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA<br>
*/
package de.webdings.tools;

/**
 * CharToInt is used to convert textual represenations
 * of integer numbers into primitive data type int.
 * 
 * @author Stefan Thesing<br>
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0.1 10.08.2005
 */
public class CharToInt {
    /**
     * @param c A char representation of an int number
     * @return int value of the represented number
     * @throws NumberFormatException
     * @throws Exception if c is not a number character.
     */
    public static int convert(char c) throws NumberFormatException 
    {
        int ascii_wert = c;
        if(ascii_wert<48 || ascii_wert>57) {
          throw new NumberFormatException("Error: " + c + "is not a number!");
        } else {
          return ascii_wert-48;
        }
    }
    
    /**
     * @param s A char array representation of an int number
     * @return int value of the represented number
     * @throws NumberFormatException
     * @throws Exception if s contains a non-number character.
     */
    public static int convert(char[] s) throws NumberFormatException 
    {
        int i;
        int ergebnis = 0;
        for(i=0;i<s.length;++i) {
          ergebnis = ergebnis*10 + convert(s[i]);
        }
        return ergebnis;
    }
    
    /**
     * @param s A String representation of an int number
     * @return int value of the represented number
     * @throws NumberFormatException
     * @throws Exception if s contains a non-number character.
     */
    public static int convert(String s) throws NumberFormatException 
    {
        return convert(s.toCharArray());
    }
    
    /**
     * @param s A StringBuffer representation of an int number
     * @return int value of the represented number
     * @throws NumberFormatException
     * @throws Exception if s contains a non-number character.
     */
    public static int convert(StringBuffer s) throws NumberFormatException 
    {
        return convert(new String(s));
    }
}
