/* CharToFloat.java - Copyright (c) 2005 by Stefan Thesing
 <p>This file is part of Webdings Tools.</p>
 <p>Webdings Tools is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.</p>
<p>Webdings Tools is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.</p>
<p>You should have received a copy of the GNU General Public License
along with Webdings Tools; if not, write to the<br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA<br>
*/
package de.webdings.tools;


/**
 * CharToFloat is used to convert textual representations
 * of float numbers to the primitive data type float.
 * 
 * @author Stefan Thesing<br>
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0.1 10.08.2005
 * 
 */
public class CharToFloat {
    /**
     * @param s A String representation of a float number
     * @return float value of the represented number
     */
    public static float convert(String s) throws NumberFormatException
    {
        Float f = new Float(s);
        return f.floatValue();
    }

    /**
     * @param c A char array representation of a float number
     * @return float value of the represented number
     */
    public static float convert(char[] c) throws NumberFormatException
    {
       int i;
       String s = new String();
       for(i=0;i<c.length;++i)
       {
         s = s + c[i];
       }
       return convert(s);
    }
    
    /**
     * @param s StringBuffer representation of a float number
     * @return float value of the represented number
     */
    public static float convert(StringBuffer s) throws NumberFormatException
    {
        return convert(new String(s));
    }
    
}
