/*
 * This file is part of Gterm.
 *
 * Gterm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


struct Settings {
  gchar *title;                  /* Terminal title */
  gchar *term;                   /* Value of TERM environment */
  gchar *wd;                     /* Initial working directory */
  gchar *cmd;                    /* Use command instead $SHELL */
  gchar *locale;                 /* Locale to use */
#ifdef USE_MENU
  gchar *menu;                   /* Menu description file */
#endif
  glong lines;                   /* Store lines */
  glong width, height;           /* Window geometry */
  PangoFontDescription *font;    /* Font to use */
  GdkColor fore, back, cursor;   /* Terminal colors */
  GdkColor *palette;             /* Terminal color palette */
  gint palsize;                  /* Palette size */
  gboolean audible, blink, login, keep, sb, is_shell;      /* Some switches */
  GHashTable *envs;              /* Set of environment variables */
};

extern struct Settings cfg;
