/*
 * This file is part of Gterm.
 *
 * Gterm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include <gtk/gtk.h>
#include <vte/vte.h>

#include "settings.h"
#include "callback.h"

#include "dnd.h"


gboolean
show_version (gchar *name, gchar *value, gpointer data, GError **error)
{
  g_printf (PACKAGE ", version " VERSION "\n");
  exit (0);
  return TRUE;
}


gboolean
set_font (gchar *name, gchar *value, gpointer data, GError **error)
{
  cfg.font = pango_font_description_from_string (value);
  return TRUE;
}


gboolean
set_cmd (gchar *name, gchar *value, gpointer data, GError **error)
{
  cfg.is_shell = FALSE;
  cfg.cmd = g_strdup (value);
  return TRUE;
}


gboolean
set_scroll (gchar *name, gchar *value, gpointer data, GError **error)
{
  if (g_ascii_strcasecmp (value, "on") == 0)
    cfg.sb = TRUE;
  else if (g_ascii_strcasecmp (value, "off") == 0)
    cfg.sb = FALSE;
  else
    return FALSE;
  return TRUE;
}

gboolean
set_color (gchar *name, gchar *value, gpointer data, GError **error)
{
  GdkColor color;
  gchar *opt = name;

  gdk_color_parse (value, &color);

  while (*opt == '-') opt++;

  if (g_ascii_strcasecmp (opt, "fore") == 0)
    cfg.fore = color;
  else if (g_ascii_strcasecmp (opt, "back") == 0)
    cfg.back = color;
  else if (g_ascii_strcasecmp (opt, "cursor") == 0)
    cfg.cursor = color;
  else
    return FALSE;
  return TRUE;
}


gboolean
set_cfg (gchar *name, gchar *value, gpointer data, GError **error)
{
  read_config (value);
  return TRUE;
}

void
add_env (gpointer key, gpointer value, gpointer data)
{
  static guint i = 0;  
  gchar **envs = (gchar **) data;

  envs[i++] = g_strconcat ((gchar *) key, "=", (gchar *) value, NULL);
}


void
child_stop (GtkWidget * w, gpointer data)
{
  if (cfg.keep)
      while (TRUE) sleep (90);
  else
      gtk_main_quit ();
}


void
window_set_title (GtkWidget *w, gpointer data)
{
  gtk_window_set_title (GTK_WINDOW (data), (VTE_TERMINAL (w))->window_title);
}


/* Get from gnome-terminal */
void
drop_data (GtkWidget *w, GdkDragContext *dc, gint x, gint y, 
	   GtkSelectionData *sel, guint info, guint t, gpointer data)
{
  gchar *str = NULL;
  
  switch (info)
    {
    case TARGET_STRING:
    case TARGET_UTF8_STRING:
    case TARGET_COMPOUND_TEXT:
    case TARGET_TEXT:
      str = g_strdup (gtk_selection_data_get_text (sel));
      break;
    case TARGET_TEXT_PLAIN:
      str = g_strdup (sel->data);
      break;
    case TARGET_MOZ_URL:
      {
	GString *str1;
	const guint16 *char_data;
	int i = 0;
	
	str1 = g_string_new (NULL);
	char_data = (const guint16*) sel->data;
	while (i < (sel->length / 2))
	  {
	    if (char_data[i] == '\n')
	      break;
	    g_string_append_unichar (str1, (gunichar) char_data[i++]);
	  }
	str = g_strdup (str1->str);
	g_string_free (str1, TRUE);
	break;
      }
    }

  vte_terminal_feed_child (VTE_TERMINAL (w), str, strlen (str));
  if (str) g_free (str);
}


#ifdef USE_MENU
int
button_pressed (GtkWidget *w, GdkEventButton *ev, gpointer data)
{
  switch (ev->button)
    {
    case 3:
    case 1:
    case 2:
    default:
      break;
    }
  return FALSE;
}
#endif
