/* stringlist.h - this file is part of the gpg-secml package.
   Copyright (C) 2007 Moritz Schulte <moritz@gnu.org>

   gpg-secml is  free software; you can redistribute  it and/or modify
   it under the  terms of the GNU General  Public License as published
   by the Free  Software Foundation; either version 2  of the License,
   or (at your option) any later version.

   gpg-secml is  distributed in the hope  that it will  be useful, but
   WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
   MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
   General Public License for more details.

   You should have  received a copy of the  GNU General Public License
   along  with   gpg-secml;  if  not,  write  to   the  Free  Software
   Foundation,  Inc.,   51  Franklin  St,  Fifth   Floor,  Boston,  MA
   02110-1301 USA  */

#ifndef GPG_SECML_STRINGLIST_H
#define GPG_SECML_STRINGLIST_H

/*
 * String-list management.
 *
 * Throughout the code slists are used.  Slists are of type char** and
 * are ALWAYS NULL-terminated.
 */

int slist_count (char **slist);

char **slist_create (void);

void slist_destroy (char **slist);

char **slist_append (char **slist, const char *elem);

char **slist_empty (char **slist);

char **slist_concat (char **slist_a, char **slist_b);

int slist_disjunct_p (char **slist_a, char **slist_b);

#endif
