/* spopen.c - this file is part of the gpg-secml package.
   Copyright (C) 2007 Moritz Schulte <moritz@gnu.org>

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "spopen.h"
#include "exechelp.h"
#include "myassert.h"

int
secure_popen_read (const char *pgmname,
		   const char *argv[],
		   spopen_read_t *spopen_obj)
{
  char *pgmname_cp;
  int err;
  int filedes[2];
  pid_t pid;
  FILE *fp;

  pgmname_cp = NULL;
  fp = NULL;
  err = 0;
  pid = -1;

  pgmname_cp = strdup (pgmname);
  MYASSERT (pgmname_cp, "failed to strdup pgmname");

  err = gnupg_create_inbound_pipe (filedes);
  MYASSERT (err == 0, "failed to create inbound pipe");

  err = gnupg_spawn_process_fd (pgmname_cp, argv, -1, filedes[1], -1, &pid);
  if (err == -1)
    {
      close (filedes[0]);
      close (filedes[1]);
      fprintf (stderr, "Failed to spawn program `%s'", pgmname_cp);
      goto out;
    }

  close (filedes[1]);

  fp = fdopen (filedes[0], "r");
  MYASSERT (fp, "failed to fdopen pipe end: %s", strerror (errno));

  spopen_obj->pgm = pgmname_cp;
  spopen_obj->readfp = fp;
  spopen_obj->pid = pid;

 out:

  return err;
}

int
secure_pclose_read (spopen_read_t spopen_obj)
{
  int exitcode;
  int err;

  err = gnupg_wait_process (spopen_obj.pgm,
			    spopen_obj.pid,
			    &exitcode);
  MYASSERT (err == 0, "Failed to run program `%s'", spopen_obj.pgm);

  fclose (spopen_obj.readfp);
  free (spopen_obj.pgm);

  return 0;
}
