/* exechelp.h - Definitions for the fork and exec helpers
 *	Copyright (C) 2004, 2007 Free Software Foundation, Inc.
 *
 * This file is part of GnuPG.
 *
 * GnuPG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GnuPG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* This is a stripped down version of GnuPG's exechelp.h.  */

#ifndef GNUPG_COMMON_EXECHELP_H
#define GNUPG_COMMON_EXECHELP_H

/* Portable function to create a pipe.  Under Windows the write end is
   inheritable.  */
int gnupg_create_inbound_pipe (int filedes[2]);

/* Fork and exec the PGMNAME, connect the file descriptor of INFILE to
   stdin, write the output to OUTFILE, return a new stream in
   STATUSFILE for stderr and the pid of the process in PID. The
   arguments for the process are expected in the NULL terminated array
   ARGV.  The program name itself should not be included there.  if
   PREEXEC is not NULL, that function will be called right before the
   exec.  Calling gnupg_wait_process is required.  Returns 0 on
   success or -1 on error. */
int gnupg_spawn_process (const char *pgmname, const char *argv[],
			 FILE *infile, FILE *outfile,
			 void (*preexec)(void),
			 FILE **statusfile, pid_t *pid);

/* Simplified version of gnupg_spawn_process.  This function forks and
   then execs PGMNAME, while connecting INFD to stdin, OUTFD to stdout
   and ERRFD to stderr (any of them may be -1 to connect them to
   /dev/null).  The arguments for the process are expected in the NULL
   terminated array ARGV.  The program name itself should not be
   included there.  Calling gnupg_wait_process is required.

   Returns 0 on success or an error code. */
int gnupg_spawn_process_fd (const char *pgmname, const char *argv[],
			    int infd, int outfd, int errfd, pid_t *pid);

/* Wait for the process identified by PID to terminate. PGMNAME should
   be the same as supplied to the spawn fucntion and is only used for
   diagnostics.  Returns 0 if the process succeded and -1 on error.
   If EXITCODE is not NULL the exit code of the process is stored at
   this address or -1 if it could not be retrieved.  */
int gnupg_wait_process (const char *pgmname, pid_t pid, int *exitcode);

#endif /*GNUPG_COMMON_EXECHELP_H*/
