/* misc.c - this file is part of the gpg-secml package.
   Copyright (C) 2007 Moritz Schulte <moritz@gnu.org>

   gpg-secml is  free software; you can redistribute  it and/or modify
   it under the  terms of the GNU General  Public License as published
   by the Free  Software Foundation; either version 2  of the License,
   or (at your option) any later version.

   gpg-secml is  distributed in the hope  that it will  be useful, but
   WITHOUT  ANY  WARRANTY;  without   even  the  implied  warranty  of
   MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
   General Public License for more details.

   You should have  received a copy of the  GNU General Public License
   along  with   gpg-secml;  if  not,  write  to   the  Free  Software
   Foundation,  Inc.,   51  Franklin  St,  Fifth   Floor,  Boston,  MA
   02110-1301 USA  */

#include <config.h>

#include <stdlib.h>
#include <string.h>

#ifndef HAVE_STRSEP
# include "strsep.h"
#endif

#include "myassert.h"

/*
 * Line parsing.
 */

char **
split_line (const char *line, const char *delims, int *n)
{
  char **fields;
  int fields_n;
  char *cp;
  char *token;

  fields_n = 0;
  cp = strdup (line);
  MYASSERT (cp, "Failed to strdup line");

  do
    {
      fields_n += 1;
      token = strsep (&cp, delims);
    }
  while (token);
  free (cp);

  fields = malloc (sizeof (char *) * fields_n);
  MYASSERT (fields, "Failed to allocate fields (fields_n = %i)", fields_n);

  fields_n = 0;
  cp = strdup (line);
  MYASSERT (cp, "Failed to strdup line");

  while ((token = strsep (&cp, delims)))
    {
      fields[fields_n] = strdup (token);
      MYASSERT (fields[fields_n], "Failed to strdup token");
      fields_n++;
    }
  free (cp);

  fields[fields_n] = NULL;
  *n = fields_n;

  return fields;
}
