/*
 * GNUjump
 * =======
 *
 * Copyright (C) 2005-2008, Juan Pedro Bolivar Puente
 *
 * GNUjump is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNUjump is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "gnujump.h"
#include "records.h"
#include "tools.h"

extern L_gblOptions gblOps;

int
loadRecords (char *fname, records_t * rtab)
{
  FILE *fh = NULL;
  int i;

  if ((fh = fopen (fname, "r")) == NULL)
    {
      printf (_
	      ("\nWARNING: Could not open records file (%s). I will create a new one later. \n"),
	      fname);
      return FALSE;
    }

  for (i = 0; i < MAX_RECORDS; i++)
    {
      rtab[i].pname = getValue_charp (fh, "player_name");
      rtab[i].floor = getValue_int (fh, "floor");
      rtab[i].mode = getValue_charp (fh, "mode");
      rtab[i].time = getValue_int (fh, "time");
      getValue_str (fh, "date", rtab[i].date, NULL);
    }

  fclose (fh);
  return TRUE;
}

int
writeRecords (char *fname, records_t * rtab)
{
  FILE *fh;
  int i;

  if ((fh = fopen (fname, "w")) == NULL)
    {
      printf (_
	      ("\nERROR: Error while opening records file (%s) for writing. \n"),
	      fname);
      return FALSE;
    }

  putComment (fh, "This file has been automatically generated by SDLjump");
  putLine (fh);

  for (i = 0; i < MAX_RECORDS; i++)
    {
      putValue_str (fh, "player_name", rtab[i].pname);
      putValue_int (fh, "floor", rtab[i].floor);
      putValue_str (fh, "mode", rtab[i].mode);
      putValue_int (fh, "time", rtab[i].time);
      putValue_str (fh, "date", rtab[i].date);
      putLine (fh);
    }

  fclose (fh);
  return TRUE;
}

int
addRecord (records_t * rtab, records_t * rec, int pos)
{
  int j;

  pos--;
  free (rtab[MAX_RECORDS - 1].pname);
  free (rtab[MAX_RECORDS - 1].mode);
  for (j = MAX_RECORDS - 1; j >= pos; j--)
    {
      rtab[j] = rtab[j - 1];
    }

  rtab[pos] = *rec;

  return FALSE;
}

int
checkRecord (records_t * rtab, int floor, int time)
{
  int i;
  for (i = 0; i < MAX_RECORDS; i++)
    {
      if (rtab[i].floor < floor)
	{
	  return i + 1;
	}
      if (rtab[i].floor == floor)
	{
	  if (time <= rtab[i].time)
	    return i + 1;
	  else
	    return i + 2;
	}
    }
  return FALSE;
}

void
makeRecord (records_t * rec, char *name, int floor, int len)
{
  struct tm *tims;
  time_t timt;

  rec->pname = NULL;
  rec->pname = malloc (sizeof (char) * (strlen (name) + 1));
  strcpy (rec->pname, name);
  rec->floor = floor;

  rec->mode = NULL;
  rec->mode = malloc (sizeof (char) * 4);
  if (gblOps.fps == FPS40)
    {
      rec->mode[0] = 'x';
    }
  else
    rec->mode[0] = 's';

  switch (gblOps.rotMode)
    {
    case ROTNONE:
      rec->mode[1] = 'n';
      break;
    case ROTORIG:
      rec->mode[1] = 'x';
      break;
    case ROTFULL:
      rec->mode[1] = 's';
      break;
    default:
      break;
    }

  switch (gblOps.scrollMode)
    {
    case HARDSCROLL:
      rec->mode[2] = 'x';
      break;
    case SOFTSCROLL:
      rec->mode[2] = 's';
    default:
      break;
    }
  rec->mode[3] = '\0';

  rec->time = len;

  timt = time (0);
  tims = localtime (&timt);
  strftime (rec->date, 64, "%H:%M %d/%m/%y", tims);
}

void
defaultRecords (records_t * rtab)
{
  int i;
  for (i = 0; i < MAX_RECORDS; i++)
    {
      makeRecord (&rtab[i], "default", (MAX_RECORDS - i) * 3, rnd (100));
    }
}

void
freeRecords (records_t * rtab)
{
  int i;
  for (i = 0; i < MAX_RECORDS; i++)
    {
      free (rtab[i].pname);
      free (rtab[i].mode);
    }
}
