<?
// GiftWeb: PHP/PostgreSQL online Gift Registry System 
// Matthew T. Jachimstal
// Copyright (C) 2000-2003  Matthew T. Jachimstal
//
// email: matthew@jachimstal.com
//
// Snail mail: Matthew Jachimstal
//             460 Washington Blvd.
//             Hoffman Estates, IL 60194
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
require "./main.inc";
require "./util.php";

$s = $_GET["s"];
$uid = validatesession($s);
$mode = $_GET["mode"];

$conn = ADONewConnection($dbtype);
$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);

if ($mode == "")
{
	startpage("Edit personal preferences", 4);
	?>
		<h2>Update personal preferences</h2>
		<p>
		<a href="editprefs.php?s=<?echo $s?>&mode=uinfo">Update user
		information</a> (Username, email, password)
		<p>
		<a href="editprefs.php?s=<?echo $s?>&mode=groups">Update group
		memberships</a> (Group to be listed in, groups to view)
		<p>
		<a href="editprefs.php?s=<?echo $s?>&mode=events">Update personal
		events</a> (Dates, descriptions)
	<?
}

if ($mode == "uinfo")
{
	startpage("Edit personal preferences", 0);

	echo "<h2>Change/update user information</h2>\n";

	if ( isset($_POST["uinfo_submit"]))
	{
		process_user_form();
// LOOK
// Don't know if I like this here. MTJ
		?>
		<meta HTTP-EQUIV="Refresh" 
                        CONTENT="3; URL=./editprefs.php?s=<?echo $s?>"><?
	}

	show_user_form();

	?>
		<center>
		<a href="editprefs.php?s=<?echo $s?>">Back to Main Preferences Page</a>
		</center>
	<?
}

if ($mode == "groups")
{
	startpage("Edit personal preferences", 0);

	echo "<h2>Update group information</h2>\n";

	if ( isset($_POST["groups_submit"]))
	{
		process_groups_form();
	}

	show_groups_form();

	?>
		<center>
		<a href="editprefs.php?s=<?echo $s?>">Back to Main Preferences Page</a>
		</center>
	<?
}

if ($mode == "events")
{
	startpage("Edit personal preferences", 0);

	echo "<h2>Update personal events</h2>\n";

	if ( isset($_POST["events_submit"]))
	{
		process_events_form();
	}

	show_events_form();

    ?>
		<center>
		<a href="editprefs.php?s=<?echo $s?>">Back to Main Preferences Page</a>
		</center>
	<?
}

function show_events_form()
{
	global $uid;
	global $conn;
	global $s;

	$sql = "SELECT * FROM events WHERE uid='$uid' ORDER BY month, day";
	$result = $conn->Execute($sql);

	?>
	<form method="post" action="editprefs.php?s=<?echo $s?>&mode=events">
	<?

	if ($result->RecordCount() == 0)
	{
		?>
		No personal events defined. Please enter them below.<p>
		Note that GiftWeb has several system-defined events (Christmas, etc).
		<br><a href="" onClick="window.open('sysevents.php', 
				'View System Events', 'width=500, height=500')">
			Click here</a> to view the system-defined events.
		<p>
		<?
	}
	else
	{
	?>
		These are the personal events which you have defined. These<br>
		will allow other users to select the event they are purchasing<br>
		an item for. After the event has passed, GiftWeb will automatically<br>
		delete those items from your list for you!
		<p>
		Note that GiftWeb has several system-defined events (Christmas, etc).
		<br><a href="" onClick="window.open('sysevents.php', 
				'View System Events', 'width=500, height=500')">
			Click here</a> to view the system-defined events.
		<p>

		<table border=1 cellpadding=4 cellspacing=0>
		<tr>
			<th>Delete</th>
			<th>Month</th>
			<th>Day</th>
			<th>Description</th>
		</tr>
	<?
							   
                $result->MoveFirst();					   
		while (!$result->EOF) 
		  {
		    $eid = chop($result->fields["eid"]);
		    $month = chop($result->fields["month"]);
		    $day = chop($result->fields["day"]);
		    $desc = chop($result->fields["description"]);
			?>
			<tr><td align=center><input type=checkbox name="ev_selected[]"
						value="<?echo $eid?>"></td>
				<td align=center><?echo $month?></td>
				<td align=center><?echo $day?></td>
				<td align=center><?echo $desc?></td>
			</tr>
			<?
		
	        $result->MoveNext();
	        }
		echo "</table>\n";
	}
	?>
	<p>
	<h3>Add an event:</h3>
	<table border=0 cellpadding=2 cellspacing=0>
	<tr><td align=right>Month:</td>
		<td align-left><input type="text" name="ev_mon" size=2 
							maxlength=2></td></tr>
	<tr><td align=right>Day:</td>
		<td align=left><input type="text" name="ev_day" size=2
							manlenght=2></td></tr>
	<tr><td align=right>Description:</td>
		<td align=left><input type="text" name="ev_desc" size=30></td></tr>
	</table>
	<p>
	<input type="submit" name="events_submit" value="Add/Delete events">
	&nbsp;
	<input type="reset" name="reset" value="Clear Form">
	</form>
	<?
}

function process_events_form()
{
	global $uid;
	global $conn;

	if (isset($_POST["ev_selected"]))
	{
		$ev_selected = $_POST["ev_selected"];

		$cnt = count($ev_selected);

		for ($i=0; $i < $cnt; $i++)
		{
			$event = $ev_selected[$i];

			$sql = "DELETE FROM events WHERE eid='$event' AND uid='$uid'";
			$result = $conn->Execute($sql);
		}
	}
		
	if (isset($_POST["ev_mon"]) && isset($_POST["ev_day"]) &&
			isset($_POST["ev_desc"]))
	{
		$ev_mon = $_POST["ev_mon"];
		$ev_day = $_POST["ev_day"];
		$ev_desc = $_POST["ev_desc"];

		$sql = "INSERT INTO events (uid, month, day, description) ";
		$sql .= "VALUES ('$uid', '$ev_mon', '$ev_day', '$ev_desc')";
		$result = $conn->Execute($sql);

	}

}



function show_user_form()
{
	global $uid;
	global $s;
	global $conn;

	$sql = "SELECT * FROM users WHERE uid='$uid'";
	$result = $conn->Execute($sql);

	$lname = chop($result->fields["last_name"]);
	$fname = chop($result->fields["first_name"]);
	$email = chop($result->fields["email"]);
	$login = chop($result->fields["login"]);


	?>
	<form method="post" action="editprefs.php?s=<?echo $s?>&mode=uinfo">
	<table border=0 cellspacing=0 cellpadding=5>
	<tr><td align=right>Login Name:</td>
		<td align=left><input type="text" name="login" value="<?echo $login?>"
			maxlength=12 size=12></td></tr>
	<tr><td align=right>First Name:</td>
		<td align=left><input type="text" name="fname" value="<?echo $fname?>"
			maxlength=25 size=25></td></tr>
	<tr><td align=right>Last Name:</td>
		<td align=left><input type="text" name="lname" value="<?echo $lname?>"
			maxlength=25 size=25></td></tr>
	<tr><td align=right>Email Address:</td>
		<td align=left><input type="text" name="email" value="<?echo $email?>"
			maxlength=40 size=40></td></tr>
	<tr></tr>
	<tr><td align=right>Change Password:</td>
		<td align=left><input type="password" name="passwd1" maxlength=12
			size=12> (Only enter a password if you wish to change it 
					permanently.)</td></tr>
	<tr><td align=right>Verify New Password:</td>
		<td align=left><input type="password" name="passwd2" maxlength=12
			size=12></td></tr>
	<tr></tr>
	<tr><td><input type="submit" name="uinfo_submit" 
				value="Submit Changes"></td>
		<td><input type="reset" value="Reset Form"></td></tr>
	</table>
	<input type="hidden" name="s" value="<?echo $s?>">
	</form>
	<?
}

//pah: I really need to understand this function better.
// does $conn->fields[] return array if there are multiple rows?
function show_groups_form()
{

  // ---------> sample
  // $recordSet = &$conn->Execute('select * from products');
  //  if (!$recordSet) 
  // print $conn->ErrorMsg();
  //else
  // while (!$recordSet->EOF) {
  //   print $recordSet->fields[0].' '.$recordSet->fields[1].'<BR>';
  //   $recordSet->MoveNext();
  // }
	global $uid;
	global $conn;
	global $s;

	// change primary group
	$sql = "SELECT * FROM members WHERE uid='$uid' and prim='t'";
	$result = $conn->Execute($sql);
	
	if ($result->RecordCount() == 1)
	{
		$p = $result->fields["prim"];
		$g = $result->fields["gid"];
		if ($p = 't')
		{
			$primary = $g;
		}
	}

	$sql = "SELECT * FROM groups ORDER BY gid";
	$result = $conn->Execute($sql);

	if($result->RecordCount() < 1)
	{
		?>
		<h3>No Groups Defined. Please contact registry administrator.</h3>
		<?
	}
	else
	{
		$prim = 0;
		$sql = "SELECT * FROM members WHERE uid='$uid' ORDER BY gid";
		$result2 = $conn->Execute($sql);

		// this should be at first already, but for consistency sake
		$result2->MoveFirst();
		
		while (!$result2->EOF) 
		{
			$group = $result2->fields["gid"];
			$selected[$group] = 1;

			if ($result2->fields["request"] == 't')
			{
				$requests[$group] = 1;
			}

			if ($result2->fields["prim"] == 't')
			{
				$prim = $group;
			}
			$result2->MoveNext();

		}
		


		?>
		Please select which group you want to be listed in. If you wish to start a new group, that can be done <a href="newgrp.php?s=<?echo $s?>">here</a>.<p>
		<form method="post" action="editprefs.php?s=<?echo $s?>&mode=groups">

		<select name="primary" size=1>
		<option value=0></option>
		<?

		$result->MoveFirst();
		while (!$result->EOF) 
		{
			$sel = "";

			$gid = $result->fields["gid"];
			$desc = $result->fields["description"];

			if ($gid == $prim)
				$sel = "selected";

			echo "<option $sel value=\"$gid\">$desc</option>\n";
			$result->MoveNext();
		}
		?>
		</select>

		<p>
		Please select which groups you would like to be able to view.<br>
		(You will always be able to view the group you are listed in.)<br>
		<table border>
		<tr><th align=center>Group Name</th>
			<th align=center></th>
		<?
		    
		$result->MoveFirst();
		while (!$result->EOF) 
		{

		  $gid = $result->fields["gid"];
		  $description = $result->fields["description"];

			?>
			<tr><td><?echo $description?></td>
				<td align=center><input type=checkbox name="requested[]"
					value="<?echo $gid?>"
					<?
					if ($selected[$gid] == 1)
						echo " checked ";
					?>
					></td>
				<td align=center>
					<?
					if ($requests[$gid] == 1)
					{
						echo "Request pending approval";
					}
					?>
				</td></tr>
			<?
				    $result->MoveNext();
                }
		?>
		</table>
		<p>
		<input type="submit" name="groups_submit" value="Submit Group Request">
		&nbsp;&nbsp;
		<input type="reset" Value="Reset Groups">
		</form>
		<?
	}
}
		
function process_user_form()
{
	global $conn;
	global $uid;

	$login = chop($_POST["login"]);
	$fname = chop($_POST["fname"]);
	$lname = chop($_POST["lname"]);
	$email = chop($_POST["email"]);
	$passwd1 = chop($_POST["passwd1"]);
	$passwd2 = chop($_POST["passwd2"]);

	$sql = "SELECT password FROM users WHERE uid='$uid'";
	$result = $conn->Execute($sql);
	$old_pass = $result->fields["password"];


	if ( $passwd1 != "" )
	{
		if ( $passwd1 == $passwd2 )
		{
			$sql = "UPDATE users SET password='$passwd1' WHERE uid='$uid'";

			$result = $conn->Execute($sql);
			if ($result->EOF)
			{
				echo "<h2>An error occured changing your password. Please";
				echo "try again.</h2>\n";
			}
			else
			{
				echo "<h3>Password changed</h3>\n";
				$old_pass = $passwd1;
				return;
			}
		}
		else
		{
			echo "<h3>Passwords entered do not match, please try again.</h3\n";
		}
	}

	$sql = "SELECT count(*) AS count FROM users where login='$login' and uid != '$uid'";
	$result = $conn->Execute($sql);

	if ( $result->fields["count"] > 0 )
	{
		echo "<h3>That login name is already taken, please choose a different login name.</h3>\n";
	}
	else
	{
		$sql = "UPDATE users SET login='$login', email='$email', ";
		$sql .= "last_name='$lname', first_name='$fname', ";
		$sql .= "password='$old_pass' WHERE uid='$uid'";
		$result = $conn->Execute($sql);


		if ($rows == EOF) //FIX  Where is $rows defines, why is it checked against EOF?
		{
			echo "<h2>An error occured updating your information, please try";
			echo "again</h2>\n";
		}
		else
		{
			echo "<h2>Your changes have been completed.</h2>\n";
		}
	}
}
		
function process_groups_form()
{
	global $conn;
	global $uid;

	// convert POST variables to normal names, makes references easier
	$primary = $_POST["primary"];
	$requested = $_POST["requested"];


	// build an associative array of which groups the user wants 
	// to be listed in (member of)
	$reqd_cnt = count($requested);

	for ($i=0; $i < $reqd_cnt; $i++)
	{
		// if $requests[gid] is 1, they want to be a member
		$requests[$requested[$i]] = 1;
	}

	//
	// check if they still want to be in their previous groups
	//
	$sql = "SELECT * FROM members WHERE uid='$uid' ORDER BY gid";
	$result = $conn->Execute($sql);
	$rows = $result->RecordCount();
	$old_prim = 0;

	
	$result->MoveFirst();
	while (!$result->EOF) 
	  {
	    $gid =  $result->fields["gid"];

		// if $requests[this_gid] is not set, they've removed that group
		if ( !$requests[$gid] )
		{
			$sql2 = "DELETE FROM members WHERE uid='$uid' and gid='$gid'";
			$conn->Execute($sql2);

			// track deleted groups for later checking WRT the primary group
			$deleted[$gid]=1;
		}
		else
		{
			// track which groups they're still in and find if it's their
			// old primary group
			$member[$gid] = 1;

			if ($result->fields["prim"]  == 't')
			{
				$old_prim = $gid;
			}
		}
		$result->MoveNext();
	  }
	

	//
	// check if they want any new groups, if it's in the requested[] array
	// but not in the member[] array, it's a new request
	//

	for ($i=0; $i < $reqd_cnt; $i++)
	{
		$grp = $requested[$i];

		// if $member[$grp] is not set, it's a new request
		if ( !$member[$grp] )
		{
			$sql = "SELECT * FROM groups WHERE gid='$grp'";
			$rslt = $conn->Execute($sql);

			if ($rslt->RecordCount() == 1)
			{
				$approve = $rslt->fields["verify_requests"];
			
				$sql3 = "INSERT INTO members VALUES ('$grp', '$uid', 'f', '$approve')";
				$conn->Execute($sql3);

				if ($approve == 't')
				{
					/*
			 		* FIX
			 		* mail the group admin about the request
			 		*/
				}
			}
		}
	}

	// see if they've changed their primary group
	$sql = "SELECT * FROM members WHERE uid='$uid' and prim='t'";
	$result = $conn->Execute($sql);

	if ($primary == 0)   // blank primary group, do nothing, user's
						 // not supposed to pick it, only used
						 // for new users, they'll get the no primary
						 // group warning from util.php
	{
	}
	else if ($result->RecordCount() == 0)  // no current primary 
	{
		if (!$deleted[$primary])  // and they've not asked to be removed
								  // from their primary group
		{
			$sql3 = "SELECT * FROM groups where gid='$primary'";
			$rslt3 = $conn->Execute($sql3);

			if ($rslt3->RecordCount() == 1)
			{
			  $approve =  $rslt3->fields["verify_requests"];
			  // just in case
			  $conn->Execute("DELETE FROM members WHERE gid='$primary' AND uid='$uid'");

			  $sql2 = "INSERT INTO members VALUES ('$primary', '$uid', 't', '$approve')";
			  $conn->Execute($sql2);

				if ($approve == 't')
				{
					/* FIX
					 * Email group admin about request
					 */
				}
			}
		}
	}
	else if ($rows == 1) // current primary group exists
	{
		if ($primary != $old_prim) // new primary group
		{
			// clear current primary
			$sql2 = "UPDATE members SET prim='f' WHERE uid='$uid'";
			$conn->Execute($sql2);

			// set new primary
			$sql2 = "UPDATE members SET prim='t' WHERE uid='$uid' ";
			$sql2 .= "and gid='$primary'";
			$conn->Execute($sql2);
		}
	}
	else    // bad number of rows
			// print an error and do nothing
	{
		?>
		<h3>There is a problem with your group listing choices. Please
		make your select and try again. If the problem persists, please
		contact the site administrator.<br>
		Thank you.</h3>
		<?
	}
	
}
endpage(4);

?>
