/**************************************************************************
 * global - Parameters of global use.
 * Version:     0.3.7 04/02/2006
 * File:        global.h
 * Description:	Functions, parameters, ..., of global use (program, library).
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#ifndef _GLOBAL_H
#define _GLOBAL_H

#include "gettext.h"

#define LENSTR      200                    // len string
#define LLENSTR     400                    // len large string
#define MAXLENROWS 2000                    // max len rows
#define MAXERR       10                    // max num err

#define MAXNOPT      30                    // man num option

#define IDMSG "%"                          // id of printed messages

#define _(String) gettext (String)
#define N_(String) gettext_noop(String)

#define false 0
#define true 1

#endif // _GLOBAL_H
