/**************************************************************************
 * file - Functions for the management of the file and the stdin and stdout.
 * Version:     0.3.8 04/02/2006
 * File:        file.c
 * Description:	Functions for the management of the file and the stdin and 
 *              stdout.
 * Error:       ID file 3, last number 06
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#include <stdio.h>
#include <string.h>
#include "global.h"
#include "ErrLog.h"
#include "BaseString.h"

/**************************************************************************
 * Function: ReadRowFile
 * Details:  Open the file, reads a row from the file, close the file. 
 *           status= "INI" action of opening, = "END" action of closing. 
 *           FFile= 0 action on file, = stdin action on stdin .
 * Returns: 
 **************************************************************************/
int ReadRowFile (FILE **FFile, char *File, char *status, char *RowOut){

  int result= true;
  char IniMess[LENSTR + 1];

  if (*FFile == stdin)
    strcpy (IniMess, "stdin");
  else
    cutparstr (IniMess, LENSTR, "File %s", File, "", "");

  if (!strcmp (status, "INI")){
    *status= '\0';
    if (*FFile != stdin && *FFile == 0L){
// prepares the reading of the file
      result= (*FFile= fopen(File, "r" )) != NULL;
      if (!result){
	strcpy (status, "END");
	ElAddErr (301, "BF", _("%s : Not readable"), IniMess, "", "");
      }
    }
  } // if (!strcmp (status, "INI"))
  else if (!strcmp (status, "END")){
// finishes the reading of the file or the stdin
    if (*FFile != stdin && *FFile != 0L){
      if (!(result= !fclose (*FFile)))
	ElAddErr (303, "BF", _("%s : Failed closing"), IniMess, "", "");
    }
  } // else if (!strcmp (status, "END"))
  else if (*status == '\0'){
// read one row from the file or the stdin 
    if (fgets (RowOut, MAXLENROWS + 1, *FFile) != NULL)
      result= CheckRow (RowOut);
    else{
      strcpy (status, "END");
      if (!(result= feof (*FFile)))
	ElAddErr (302, "BF", _("%s : Error during the reading"), IniMess, "", "");
    }
  } // else if (*status == '\0')
  else{
    result= false;
    strcpy (status, "???");
  }

  return (result);    
} // ReadRowFile

/**************************************************************************
 * Function: WriteRowFile
 * Details:  Open the file, write a row in the file, close the file. 
 *           status= "INI" action of opening, = "END" action of closing. 
 *           FFile= 0 action on file, = stdin action on stdout.
 * Returns: 
 **************************************************************************/
int WriteRowFile (FILE **FFile, char *File, char *status, char *RowIn, int NewLine){

  int result= true;
  char IniMess[LENSTR + 1];

  if (*FFile == stdout)
    strcpy (IniMess, "stdout");
  else
    cutparstr (IniMess, LENSTR, "File %s", File, "", "");

  if (!strcmp (status, "INI")){
    *status= '\0';
    if (*FFile != stdout && *FFile == 0L){
// prepares the writing of the file
      result= (*FFile= fopen(File, "w" )) != NULL;
      if (!result){
	strcpy (status, "END");
	ElAddErr (304, "BF", _("%s : Not writable"), IniMess, "", "");
      }
    }
  } // if (!strcmp (status, "INI"))
  else if (!strcmp (status, "END")){
// finishes the writing of the file or the stdout
    if (*FFile != stdout && *FFile != 0L){
      if (!(result= !fclose (*FFile)))
	ElAddErr (306, "BF", _("%s : Failed closing"), IniMess, "", "");
    }
    *IniMess= '\0';
  } // else if (!strcmp (status, "END"))
  else if (*status == '\0'){
// write the row in the file or the stdout
    if (result= fputs (RowIn, *FFile) != 0){
      if (NewLine)
	result= fputs ("\n", *FFile) != 0;
    }
    if (!result){
      strcpy (status, "END");
      ElAddErr (305, "BF", _("%s : Error during the writing"), IniMess, "", "");
    }
  } // else if (*status == '\0')
  else{
    result= false;
    strcpy (status, "???");
  }

  return (result);    
} // WriteRowFile
